---
html:
    toc: true  //侧边目录
    embed_local_images: true  //图片嵌入为base64格式
---
<style>
  table {
    width: 100%; /* 或者具体的像素值，例如：1200px */
    table-layout: fixed; /* 保持列宽固定 */
  }
  th, td {
    word-wrap: break-word; /* 允许文本换行 */
  }
  .delline{
    text-decoration:line-through;
  }
  .yellowFill{
    background-color: yellow;
  }
</style>
[TOC]
<br>
<br>
<br>

<div  style="text-align: center;font-size: 70px;">
SunVote B200W <br>MQTT通讯协议
</div>
<br>
<br>
<br>
<br>
<div  style="text-align: center;font-size: 30px;">
Ver 1.0.3
</div>
<br>
<br>
<br>
<br>
<br>
<br>

<div  style="text-align: center;font-size: 30px;">
长沙中天电子设计开发有限公司
</div>

<br>

<div  style="text-align: center;font-size: 30px;">
二〇二五年三月
</div>

<br>
<br>
<br>
<br>

文件控制：

文件名：SunVote B200W MQTT通讯协议

起草人：刘琴

最新版本作者： 刘琴
<br>
| 文档版本 | 日期 | 作者 | 版本说明 |
|---|---|---|---|
|1.0.1| 2024年10月22日|刘琴|1.  初始版|
|1.0.2| 2024年12月27日|刘琴|1. 增加测验题和多科测验中自判题题型<br>2. 多科测验的科目数量为从9增加至11<br>3. 增加测验自定义题型标题下发和清除<br>4. 可自定义最长128位的数据包标签<br><font color=red>注：(基站固件版本需不低于0.0.9)</font>|
|1.0.3| 2025年3月24日|刘琴|1. 增加文本题和短消息题型<br>2. 增加键盘在线列表读取<br>3. 增加遥控器事件上报 <br>4. 增加fEvtKpBindingInfo、fEvtSetKpUserPrompt、fEvtKpMsg事件中state为2的参数错误返回 <br><inner>5. 内部指令增加恢复键盘出厂设置 <br></inner><font color=red>注：(基站固件版本需不低于0.0.10)</font>|

<br>
<br>

# SunVote B200W MQTT通讯协议

# 功能说明

## 主题说明
{baseSN}为指定的基站的SN编码，不能为空，接收基站反馈数据需要订阅对应基站SN的接收主题。
### 发布的主题
应用程序发布的主题，基站订阅
/client/{baseSN}/send
/client/multiBase/send

<inner>
  <span class="yellowFill">内部应用发布的主题，基站订阅
  /manage/{baseSN}/send</span>
</inner>

### 订阅的主题
应用程序订阅的主题，基站发布
/basestation/\{baseSN}/receive
/basestation/multiBase/receive 

<inner>
<span class="yellowFill">内部应用订阅的主题，基站发布
/manage/{baseSN}/receive</span>
</inner>

## 指令说明
|指令功能标识	|说明	|约束|
|---|---|---|
|get|	待机状态下获取参数属性状态及数据	|待机状态|
|set|	待机状态下设置参数属性状态及数据	|待机状态|
|start|	运行一个单进程业务实例（函数）	|待机状态|
|stop|	停止一个单进程业务实例（函数）	|待机状态|
|rtXXX|	在线状态下可实时执行方法及函数	||

## 事件说明
|事件标识|	说明|	约束|
|---|---|---|
|sEvtXXX|系统事件	|自动返回|
|fEvtXXX|指令事件	|调用对应指令后返回|

## 数据格式约定
- 数据格式统一为**Json**格式，发送接收消息编码统一为**UTF-8**
- Json通用格式如下：

```json
  {
    "fun":"xxx", 
    "dataTag":"xxx", 
    "data":{    
       //内容
    }
  }
```

|参数	|说明	|约束|
|---|---|---|
|fun|	指令或事件名称||
|dataTag|	数据标签，用于对应收发数据|长度不超过128个字符，可以为字母数字下划线"_"的组合，区分大小写|
|data|	数据内容|对象或者数组，可为空|

<font color="red">注意：基站接收指令数据单次不超过2K长度，在指定键盘发送指令时，如果指令长度超出限制，建议将指令进行拆分，分次发送，如果是所有键盘执行的指令，可将keySns设为空数组不使用指定键盘的模式</font>


## 功能速查一览表
### 公共方法
可以在多种业务中调用的通用方法
|功能归类|功能|API指令|指令/系统事件|
|---|---|---|---|
|停止投票|可停止通过调用startXXX启动的答题业务|[stopKpVote](#stopkpvote)|[sEvtStateCode](#sevtstatecode)||

### 公共事件
无需调用指令，自动返回的事件
|功能归类|功能|API指令|指令/系统事件|
|---|---|---|---|
|公共事件|指令接收状态|-|[sEvtStateCode](#sevtstatecode)|
|公共事件|基站连接状态变化|-|[sEvtBsConnectState](#sevtbsconnectstate)|
|公共事件|基站信道冲突|-|[sEvtBsChannelConflict](#sevtbschannelconflict)|
|公共事件|键盘上线通知|-|[sEvtBsKpOnlineMsg](#sevtbskponlinemsg)|
|公共事件|键盘离线通知|-|[sEvtBsKpOfflineMsg](#sevtbskpofflinemsg)|
|公共事件|键盘刷卡事件|-|[sEvtBsNfcResults](#sevtbsnfcresults)|
|公共事件|在线键盘列表|-|[sEvtBsKpOnlineList](#sevtbskponlinelist)|
|公共事件|键盘待机实时按键反馈|-|[sEvtKpRtFeedback](#sevtkprtfeedback)|
|公共事件|键盘举手键实时按键反馈|-|[sEvtKpHandUp](#sevtkphandup)|
|公共事件|遥控器实时按键反馈|-|[sEvtKpRemoteControl](#sevtkpremotecontrol)|

### 基站管理
|功能归类|功能|API指令|指令/系统事件|
|---|---|---|---|
|基站连接 - 获取在线基站|主动获取在线基站信息<br>不确定基站SN时|[getBsOnlineState](#getbsonlinestate)|[fEvtBsOnlineState](#fevtbsonlinestate)||
|基站连接 - 主动获取状态|主动获取基站连接状态|[getBsConnectState](#getbsconnectstate)|[sEvtBsConnectState](#sevtbsconnectstate)||
|基站连接 - 自动获取状态|基站连接变化系统通知|-|[sEvtBsConnectState](#sevtbsconnectstate)||
|基站授时|对基站授时用于校准时间|[timeSync](#timesync)|[sEvtStateCode](#sevtstatecode)||
|键盘上线通知|单个键盘上线系统通知|-|[sEvtBsKpOnlineMsg](#sevtbskponlinemsg)||<inner>
|识别设置 - 出厂编码|<font color="red">设置基站出厂编码(内)|[setBsSN](#setbssn)|[fEvtBsSN](#fevtbssn)|</inner>
|识别设置 - 基站型号|读取基站型号|[getBsModel](#getbsmodel)|[fEvtBsModel](#fevtbsmodel)|
|识别设置 - 固件版本|获取基站固件版本|[getBsFWVersion](#getbsfwversion)|[fEvtBsFWVersion](#fevtbsfwversion)|<inner>
|识别设置 - 品牌识别码|<font color="red">获取基站品牌识别码(内)</font>|[getBsBIC](#getbsbic)|[fEvtBsBIC](#fevtbsbic)|
||<font color="red">设置基站品牌识别码(内)|[setBsBIC](#setbsbic)|[fEvtBsBIC](#fevtbsbic)|</inner>
|组网设置 - 组网模式|获取基站组网模式|[getBsNetworkMode](#getbsnetworkmode)|[fEvtBsNetworkMode](#fevtbsnetworkmode)|<inner>
||<font color="blue">设置基站组网模式<br>(前期不开放，后期需要)|[setBsNetworkMode](#setbsnetworkmode)|[fEvtBsNetworkMode](#fevtbsnetworkmode)|</inner>
|组网设置 - 配对码|获取基站配对码|[getBsPairCode](#getbspaircode)|[fEvtBsPairCode](#fevtbspaircode)|<inner>
||<font color="red">设置基站配对码(内)</font>|[setBsPairCode](#setbspaircode)|[fEvtBsPairCode](#fevtbspaircode)|</inner>
|组网设置 - 刷卡配对状态|获取刷卡配对状态|[getBsNfcLogin](#getbsnfclogin)|[fEvtBsNfcLogin](#fevtbsnfclogin)|
||设置刷卡配对状态|[setBsNfcLogin](#setbsnfclogin)|[fEvtBsNfcLogin](#fevtbsnfclogin)||
|组网设置 - 工作信道|获取基站工作信道|[getBsChannel](#getbschannel)|[fEvtBsChannel](#fevtbschannel)|
||设置基站工作信道|[setBsChannel](#setbschannel)|[fEvtBsChannel](#fevtbschannel)||
||读取已被占用信道|[getBsRFIChannel](#getbsrfichannel)|[fEvtBsRFIChannel](#fevtbsrfichannel)||
|登录设置 - 登录名称|获取基站登录名称|[getBsSSID](#getbsssid)|[fEvtBsSSID](#fevtbsssid)|
||设置基站登录名称|[setBsSSID](#setbsssid)|[fEvtBsSSID](#fevtbsssid)||
|登录设置 - 登录密码|获取基站登录密码|[getBsLoginPwd](#getbsloginpwd)|[fEvtBsLoginPwd](#fevtbsloginpwd)|
||设置基站登录密码|[setBsLoginPwd](#setbsloginpwd)|[fEvtBsLoginPwd](#fevtbsloginpwd)||
|登录设置 - 基站登录状态|获取基站登录状态|[getBsLoginState](#getbsloginstate)|[fEvtBsLoginState](#fevtbsloginstate)|
||设置基站登录状态|[setBsLoginState](#setbsloginstate)|[fEvtBsLoginState](#fevtbsloginstate)||
|键盘统一设置 - 键盘语言|获取键盘语言|[getBsKpLanguage](#getbskplanguage)|[fEvtBsKpLanguage](#fevtbskplanguage)|
||设置键盘语言|[setBsKpLanguage](#setbskplanguage)|[fEvtBsKpLanguage](#fevtbskplanguage)||
|键盘统一设置 - 状态语模式|获取状态语设置状态|[getBsKpStbMsgMode](#getbskpstbmsgmode)|[fEvtBsKpStbMsgMode](#fevtbskpstbmsgmode)|
||设置状态语工作状态|[setBsKpStbMsgMode](#setbskpstbmsgmode)|[fEvtBsKpStbMsgMode](#fevtbskpstbmsgmode)|||
|键盘统一设置 - 登录菜单|获取键盘登录菜单状态|[getBsKpLoginMenu](#getbskploginmenu)|[fEvtBsKpLoginMenu](#fevtbskploginmenu)|
||设置键盘登录菜单状态|[setBsKpLoginMenu](#setbskploginmenu)|[fEvtBsKpLoginMenu](#fevtbskploginmenu)|||
|键盘统一设置 - 长距考勤|获取键盘长距考勤状态|[getBsKpRFIDState](#getbskprfidstate)|[fEvtBsKpRFIDState](#fevtbskprfidstate)|
||设置键盘长距考勤状态|[setBsKpRFIDState](#setbskprfidstate)|[fEvtBsKpRFIDState](#fevtbskprfidstate)|<inner>
|键盘统一设置 - 键盘休眠|<font color="red">设置键盘休眠等级(内)</font>|[setBsKpSleepLevel](#setbskpsleeplevel)|[fEvtBsKpSleepLevel](#fevtbskpsleeplevel)|
||<font color="red">获取键盘休眠等级(内)</font>|[getBsKpSleepLevel](#getbskpsleeplevel)|[fEvtBsKpSleepLevel](#fevtbskpsleeplevel)|
||<font color="red">设置键盘暂停休眠状态(内)</font>|[setBsKpPauseSleep](#setbskppausesleep)|[fEvtBsKpPauseSleep](#fevtbskppausesleep)|
||<font color="red">获取键盘暂停休眠状态(内)</font>|[getBsKpPauseSleep](#getbskppausesleep)|[fEvtBsKpPauseSleep](#fevtbskppausesleep)|</inner>
|配对模式 - 快速配对|启动基站快速配对|[startBsFastPair](#startbsfastpair)|[sEvtStateCode](#sevtstatecode)<br>[sEvtBsKpOnlineMsg](#sevtbskponlinemsg)|
||停止基站快速配对|[stopBsFastPair](#stopbsfastpair)|[sEvtStateCode](#sevtstatecode)|
|白名单模式 - 白名单管理|获取白名单|[getBsWhitelist](#getbswhitelist)|[fEvtBsWhitelist](#fevtbswhitelist)|
||设置白名单|[setBsWhitelist](#setbswhitelist)|[sEvtStateCode](#sevtstatecode)<br>[fEvtSetBsWhitelist](#fevtsetbswhitelist)|
||清空白名单|[clearBsWhitelist](#clearbswhitelist)|[sEvtStateCode](#sevtstatecode)<br>[fEvtBsWhitelist](#fevtbswhitelist)|
||增加白名单|[addBsWhitelist](#addbswhitelist)|[sEvtStateCode](#sevtstatecode)<br>[fEvtAddBsWhitelist](#fevtaddbswhitelist)<br>[fEvtBsWhitelist](#fevtbswhitelist)|
||删除白名单|[delBsWhitelist](#delbswhitelist)|[sEvtStateCode](#sevtstatecode)<br>[fEvtDelBsWhitelist](#fevtdelbswhitelist)<br>[fEvtBsWhitelist](#fevtbswhitelist)|
|基站加密 - 软件狗|获取基站软件狗|[getBsSoftwareKey](#getbssoftwarekey)|[fEvtBsSoftwareKey](#fevtbssoftwarekey)|
||设置基站软件狗|[setBsSoftwareKey](#setbssoftwarekey)|[fEvtBsSoftwareKey](#fevtbssoftwarekey)|
|网络设置 - TCP/IP参数|获取TCP/IP参数|[getBsTcpipParams](#getbstcpipparams)|[fEvtBsTcpipParams](#fevtbstcpipparams)|
||设置TCP/IP参数|[setBsTcpipParams](#setbstcpipparams)|[fEvtBsTcpipParams](#fevtbstcpipparams)||
|网络设置 - MQTT参数|获取MQTT参数|[getBsMqttParams](#getbsmqttparams)|[fEvtBsMqttParams](#fevtbsmqttparams)|
||设置MQTT参数|[setBsMqttParams](#setbsmqttparams)|[fEvtBsMqttParams](#fevtbsmqttparams)||<inner>
|基站维护|<font color="red">获取基站日志信息(内)</font>|[getBsLogInfo](#getbsloginfo)|[sEvtStateCode](#sevtstatecode)<br>[fEvtBsLogInfo](#fevtbsloginfo)|
||<font color="red">清空基站日志(内)</font>|[clearBsLogInfo](#clearbsloginfo)|[sEvtStateCode](#sevtstatecode)|
||基站软复位|[resetBsSystem](#resetbssystem)|[sEvtStateCode](#sevtstatecode)<br>[sEvtBsConnectState](#sevtbsconnectstate)|
||基站断电复位|[resetBsPower](#resetbspower)|[sEvtStateCode](#sevtstatecode)<br>[sEvtBsConnectState](#sevtbsconnectstate)|
||<font color="red">基站自检(内)</font>|[startBsSelfCheck](#startbsselfcheck)|[sEvtStateCode](#sevtstatecode)<br>[fEvtBsSelfCheck](#fevtbsselfcheck)|
|基站升级|<font color="red">开启基站升级(内)|[startBsUpdate](#startbsupdate)|[sEvtStateCode](#sevtstatecode)<br>[fEvtBsUpateState](#fevtbsupatestate)<br>[fEvtBsUpdateProgress](#fevtbsupdateprogress)|
||<font color="red">下载字库(内)|[downloadFontLib](#downloadfontlib)|[sEvtStateCode](#sevtstatecode)<br>[fEvtBsFontLibState](#fevtbsfontlibstate)<br>[fEvtBsFontLibProgress](#fevtbsfontlibprogress)|</inner>
### 键盘管理
|功能归类|功能|API指令|指令事件|
|---|---|---|---|
|交互设置 - 用户内置状态语|设置用户内置状态语|[setKpUserStbMsg](#setkpuserstbmsg)|[fEvtKpUserStbMsg](#fevtkpuserstbmsg)|
|交互设置 - 用户实时提示反馈信息|实时设置提示反馈信息|[rtSetKpUserPrompt](#rtsetkpuserprompt)|[sEvtStateCode](#sevtstatecode)<br>[fEvtSetKpUserPrompt](#fevtsetkpuserprompt)|<inner>
|<font color="red">识别设置 - 出厂编码(内)|<font color="red">设置键盘出厂编码(内)|[setKpSN](#setkpsn)|[fEvtSetKpSN](#fevtsetkpsn)<br>|
|<font color="red">识别设置 - 键盘编号(内)|<font color="red">设置键盘编号(内)|[setKpID](#setkpid)|[fEvtSetKpID](#fevtsetkpid)|
|<font color="red">识别设置 - 键盘信息(内)|<font color="red">开始获取键盘信息(内)|[startGetKpInfo](#setkpid)|[sEvtStateCode](#sevtstatecode)<br>[fEvtKpInfo](#fevtkpinfo)|
||<font color="red">停止获取键盘信息(内)|[stopGetKpInfo](#setkpid)|[sEvtStateCode](#sevtstatecode)|</inner>
|在线状态获取|开启扫描在线键盘|[startGetKpOnline](#startgetkponline)|[sEvtStateCode](#sevtstatecode)<br>[fEvtKpOnlineMsg](#fevtkponlinemsg)|
||停止扫描在线键盘|[stopGetKpOnline](#stopgetkponline)|[sEvtStateCode](#sevtstatecode)|
||实时获取在线键盘列表|[rtGetKpOnlineList](#rtgetkponlinelist)|[sEvtBsKpOnlineList](#sevtbskponlinelist)|
|维护功能 - 遥控功能|遥控键盘休眠|[remoteKpSleep](#remotekpsleep)|[sEvtStateCode](#sevtstatecode)|<inner>
|维护功能 - 键盘升级|<font color="red">启动键盘无线升级(内)|[startKpFWUpdate](#startkpfwupdate)|[sEvtStateCode](#sevtstatecode)<br>[fEvtKpFWUpdateState](#fevtkpfwupdatestate)<br>[fEvtKpUpdateProgress](#fevtkpupdateprogress)<br>[sEvtBsKpOnlineMsg](#sevtbskponlinemsg)|
||<font color="red">停止键盘无线升级(内)|[stopKpFWUpdate](#stopkpfwupdate)|[sEvtStateCode](#sevtstatecode)<br>[fEvtKpFWUpdateState](#fevtkpfwupdatestate)|
|维护功能 - 恢复出厂|恢复键盘出厂设置|[resetKpDefault](#resetkpdefault)|[sEvtStateCode](#sevtstatecode)|</inner>
### 绑定
|功能归类|功能|API指令|指令事件|
|---|---|---|---|
|无线绑定|设置绑定信息到键盘|[rtSetKpBindingInfo](#rtsetkpbindinginfo)|[sEvtStateCode](#sevtstatecode)<br>[fEvtKpBindingInfo](#fevtkpbindinginfo)|
||清除键盘绑定信息|[clearKpBindingInfo](#clearkpbindinginfo)|[sEvtStateCode](#sevtstatecode)<br>[fEvtClearKpBindingInfo](#fevtclearkpbindinginfo)|
### 签到
|功能归类|功能|API指令|指令事件|
|---|---|---|---|
|同步签到|启动同步签到|[startKpSignIn](#startkpsignin)|[sEvtStateCode](#sevtstatecode)<br>[fEvtKpSignIn](#fevtkpsignin)|
||停止同步签到|[stopKpVote](#stopkpvote)|[sEvtStateCode](#sevtstatecode)|
|随时签到|启动随时签到|[rtStartKpSignIn](#rtstartkpsignin)|[sEvtStateCode](#sevtstatecode)<br>[fEvtKpSignIn](#fevtkpsignin)|
||停止随时签到|[rtStopKpSignIn](#rtstopkpsignin)|[sEvtStateCode](#sevtstatecode)|
||实时PIN签到授权|[rtSetKpLoginAllowed](#rtsetkploginallowed)|[sEvtStateCode](#sevtstatecode)<br>[fEvtKpLoginAllowed](#fevtkploginallowed)|
### 按键反馈
|功能归类|功能|API指令|指令事件|
|---|---|---|---|
|判断题|启动判断题答题|[startQATrueFalse](#startqatruefalse)|[sEvtStateCode](#sevtstatecode)<br>[fEvtQATrueFalse](#fevtqatruefalse)|
||停止判断题答题|[stopKpVote](#stopkpvote)|[sEvtStateCode](#sevtstatecode)|
|选择题|启动选择题答题|[startQAChoice](#startqachoice)|[sEvtStateCode](#sevtstatecode)<br>[fEvtQAChoice](#fevtqachoice)|
||停止选择题答题|[stopKpVote](#stopkpvote)|[sEvtStateCode](#sevtstatecode)|
|数字题|启动数字题答题|[startQANum](#startqanum)|[sEvtStateCode](#sevtstatecode)<br>[fEvtQANum](#fevtqanum)|
||停止数字题答题|[stopKpVote](#stopkpvote)|[sEvtStateCode](#sevtstatecode)|
|抢答题|启动抢答题答题|[startQAQuicker](#startqaquicker)|[sEvtStateCode](#sevtstatecode)<br>[fEvtQAQuicker](#fevtqaquicker)|
||停止抢答题答题|[stopKpVote](#stopkpvote)|[sEvtStateCode](#sevtstatecode)|
|文本题|启动文本题答题|[startQAEText](#startqaetext)|[sEvtStateCode](#sevtstatecode)<br>[fEvtQAEText](#fevtqaetext)|
||停止文本题答题|[stopKpVote](#stopkpvote)|[sEvtStateCode](#sevtstatecode)|
|短消息|发送短消息|[sendKpMsg](#sendkpmsg)|[sEvtStateCode](#sevtstatecode)<br>[fEvtKpMsg](#fevtkpmsg)|
|待机实时反馈|设置待机实时反馈状态|[setKpStbResponse](#setkpstbresponse)|[fEvtKpStbResponse](#fevtkpstbresponse)<br>[sEvtKpRtFeedback](#sevtkprtfeedback)<br>[sEvtKpHandUp](#sevtkphandup)|
||获取待机实时反馈状态|[getKpStbResponse](#getkpstbresponse)|[fEvtKpStbResponse](#fevtkpstbresponse)|
### 在线测验
|功能归类|功能|API指令|指令事件|
|---|---|---|---|
|标准测验|启动标准测验|[startKpExam](#startkpexam)|[sEvtStateCode](#sevtstatecode)<br>[fEvtKpExam](#fevtkpexam)<br>[fEvtFinalSubmit](#fevtfinalsubmit)|
||停止标准测验|[stopKpVote](#stopkpvote)|[sEvtStateCode](#sevtstatecode)|<inner>
||刷新作答数据|[rtGetKpExamData](#rtgetkpexamdata)|[sEvtStateCode](#sevtstatecode)<br>[fEvtKpExam](#fevtkpexam)|</inner>
||允许键盘提交后退回修改|[rtAllowEdited](#rtkpallowedited)|[sEvtStateCode](#sevtstatecode)<br>[fEvtFinalSubmit](#fevtfinalsubmit)|
|多科测验|启动多科测验|[startKpMultiExam](#startkpmultiexam)|[sEvtStateCode](#sevtstatecode)<br>[fEvtKpExam](#fevtkpexam)<br>[fEvtFinalSubmit](#fevtfinalsubmit)|
||停止标准测验|[stopKpVote](#stopkpvote)|[sEvtStateCode](#sevtstatecode)|
|自主录分|启动自主录分|[startKpScoreInput](#startkpscoreinput)|[sEvtStateCode](#sevtstatecode)<br>[fEvtKpScore](#fevtkpscore)<br>[fEvtFinalSubmit](#fevtfinalsubmit)|
||停止自主录分|[stopKpVote](#stopkpvote)|[sEvtStateCode](#sevtstatecode)|
|自定义测验题型标题|自定义测验题型标题内容|[setKpExamQuesTitle](#setKpexamquestitle)|[sEvtStateCode](#sevtstatecode)<br>[fEvtKpExamQuesTitle](#fevtkpexamquestitle)|
||清除自定义测验题型标题内容|[clearKpExamQuesTitle](#clearkpexamquestitle)|[sEvtStateCode](#sevtstatecode)<br>[fEvtClearKpExamQuesTitle](#fevtclearkpexamquestitle)|

## 公共方法
### stopKpVote
- **主题**: /client/{baseSN}/send
- **功能描述**：通用停止键盘答题方法，可以停止如同步签到、按键反馈、在线测验中调用startXXX方法启动的业务
- **参数说明**

|参数名|类型|限制|非空|说明|
|-----|-----|-----|-----|-----|
|fun|string|-|是|事件类型|
|dataTag|string||否|数据包标识，不需要时可传空字符串|

- **示例代码**
```json
{
    "fun":"stopKpVote",
    "dataTag":"1"
}
```

## 公共事件
### sEvtBsConnectState
- **主题**: /basestation/{baseSN}/receive
- **功能描述**：基站连接成功时返回基站型号和基站SN,基站从已连接状态断开返回连接断开
- **参数说明**

|参数名|类型|限制|非空|说明|
|-----|-----|-----|-----|-----|
|fun|string|-|是|事件类型|
|dataTag|string||否|数据包标识，不需要时可传空字符串|
|data|object|-|是|传送参数的对象|
|+baseModel|int||否|基站的型号码|
|+modelName|string||否|基站的型号名称|
|+state|int||是|基站的连接状态<br>1-已连接<br>2-连接断开|
|+version|string||否|基站固件版本|

- **示例代码**
```json
//连接成功
{
    "fun":"sEvtBsConnectState",
    "dataTag":"1",
    "data":{  
        "state":1,      
        "baseModel":218,
        "modelName":"B200",
        "version":"1.0.3"
    }
}
//连接断开
{
    "fun":"sEvtBsConnectState",
    "dataTag":"1",
    "data":{        
        "state":2
    }
}
```
### sEvtBsChannelConflict
- **主题**: /basestation/{baseSN}/receive
- **功能描述**：基站信道冲突时主动上报，应用程序可根据实际业务修改基站信道
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|事件名称|
|dataTag|string|-|否|数据包标识，不需要时可传空字符串|
|data|object|-|是|传送参数的对象|
|+value|int||是|有冲突的信道|

- **示例代码**
```json
{
    "fun":"sEvtBsChannelConflict",
    "dataTag":"1",
    "data":{        
        "value":5   //信道5有多个基站使用
    }
}
```
### sEvtBsNfcResults
- **主题**: /basestation/{baseSN}/receive
- **功能描述**：键盘刷卡时主动上报，如果超出基站容量会上报失败
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|事件名称|
|dataTag|string|-|否|数据包标识，不需要时可传空字符串|
|data|object|-|是|传送参数的对象|
|+keySn|string||是|刷卡的键盘SN|
|+cardType|int||是|刷卡的键盘类型<br>1-NFC类型<br>2-M1类型|
|+value|int||是|刷卡的状态<br>1-成功<br>2-失败|

- **示例代码**
```json
{
    "fun":"sEvtBsNfcResults",
    "dataTag":"1",  //不需要时可传空字符串
    "data":{ 
        "keySn":"1234567890",    
        "cardType":1,   
        "value":1   
    }
}
```

### sEvtBsKpOnlineMsg
- **主题**: /basestation/{baseSN}/receive
- **功能描述**：键盘上线通知，主动上报,键盘升级成功后也会上报
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|事件名称|
|dataTag|string|-|否|数据包标识|
|data|object|-|是|传送参数的对象|
|+keySn|string||是|键盘SN|
|+version|string||是|键盘固件版本|
|+model|int||是|键盘型号|

- **示例代码**
```json
{
    "fun":"sEvtBsKpOnlineMsg",
    "dataTag":"1",
    "data":{ 
        "keySn":"1234567890",
        "version":"1.0.0",
        "model":67
    }
}
```

### sEvtBsKpOfflineMsg
- **主题**: /basestation/{baseSN}/receive
- **功能描述**：单个键盘离线通知，主动上报
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|事件名称|
|dataTag|string|-|否|数据包标识|
|data|object|-|是|传送参数的对象|
|+keySn|string||是|键盘SN|

- **示例代码**
```json
{
    "fun":"sEvtBsKpOfflineMsg",
    "dataTag":"1",
    "data":{ 
        "keySn":"1234567890"
    }
}
```

### sEvtBsKpOnlineList
- **主题**: /basestation/{baseSN}/receive
- **功能描述**：键盘在线列表发生变化时主动上报
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|事件名称|
|dataTag|string|-|否|数据包标识|
|data|array|-|是|传送参数的对象数组|
|++keySn|string||是|键盘SN|
|++version|string||是|键盘固件版本|
|++model|int||是|键盘型号|
|++voltage|double||是|键盘电压|

- **示例代码**
```json
{
    "fun":"sEvtBsKpOnlineList",
    "dataTag":"1",
    "data":[{ 
        "keySn":"1234567890",
        "version":"1.0.0",
        "model":67,
        "voltage":2.8
    },{ 
        "keySn":"1234567891",
        "version":"1.0.0",
        "model":67,
        "voltage":2.8
    }]
}
```
### sEvtKpRtFeedback
- **主题**: /basestation/{baseSN}/receive
- **功能描述**：开启键盘实时反馈后，键盘按键时上报
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|事件名称|
|dataTag|string|-|否|数据包标识|
|data|array|-|是|传送参数的对象数组|
|++keySn|string||是|键盘SN|
|++keyValue|string||是|键盘提交的按键值|
|++voltage|double||是|键盘电量|
|++retryCount|int||是|键盘提交数据的重发次数|

- **示例代码**
```json
{
    "fun":"sEvtKpRtFeedback",
    "dataTag":"1",
    "data":[{ 
        "keySn":"1234567890",
        "keyValue":"A",
        "voltage":2.6,
        "retryCount":1
    }]
}
```
### sEvtKpHandUp
- **主题**: /basestation/{baseSN}/receive
- **功能描述**：开启键盘举手功能后，键盘按举手键时上报
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|事件名称|
|dataTag|string|-|否|数据包标识|
|data|object|-|是|传送参数的对象|
|+keySn|string||是|举手的键盘SN|

- **示例代码**
```json
{
    "fun":"sEvtKpHandUp",
    "dataTag":"1",
    "data":{ 
        "keySn":"1234567890"
    }
}
```
### sEvtKpRemoteControl
- **主题**: /basestation/{baseSN}/receive
- **功能描述**：遥控器按键实时上报
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|事件名称|
|dataTag|string|-|否|数据包标识|
|data|object|-|是|传送参数的对象|
|+keySn|string||是|遥控器SN|
|+keyValue|string||是|遥控器提交的按键值，按键值含义参见遥控器说明|

- **示例代码**
```json
{
    "fun":"sEvtKpRemoteControl",
    "dataTag":"1",
    "data":{ 
        "keySn":"1234567890",
        "keyValue":"1"
    }
}
```
### sEvtStateCode
- **主题**: /basestation/{baseSN}/receive
- **功能描述**：返回基站接收指令状态信息
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|事件名称|
|dataTag|string|-|否|数据包标识|
|data|object|-|是|传送参数的对象|
|+funName|string||是|指令名称|
|+code|string||是|状态码，含义见下表|

|状态码|说明|
|---|---|
|0|指令收取成功|
|10001|不能正确解析的JSON数据|
|10002|解析JSON错误|
|10003|下发数据包超长|
|20001|基站未连接|
|20002|功能不支持|
|20003|基站SN格式不正确|
|20004|参数错误|
|20005|dataTag错误|
|20006|键盘SN错误|
|20007|tip参数错误|
|20008|value参数错误|
|30001|基站在答题中|
|30002|基站忙(内存不足)|
|30003|基站执行失败|
|40001|升级功能只能支持一个基站|
|50001|此功能必须指定基站|
|60001|此功能必须指定键盘SN|
|70001|没有字库|

- **示例代码**
```json
{
    "fun":"sEvtStateCode",
    "dataTag":"1",
    "data":{ 
        "funName":"startKpSignIn",
        "code":"20005"
    }
}
```
## 基站管理
### 基站连接
#### 方法
##### getBsOnlineState
- **主题**：<span class="yellowFill">/client/multiBase/send</span>
- **功能描述**：主动获取所有在线基站信息,在线基站回复
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|固定指令名称|
|dataTag|string|-|否|数据包标识|
- **示例代码**
```json
{
  "fun":"getBsOnlineState",
  "dataTag":"1"
}
```

##### getBsConnectState
- **主题**：/client/{baseSN}/send
- **功能描述**：主动获取基站连接状态
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|固定指令名称|
|dataTag|string|-|否|数据包标识|
- **示例代码**
```json
{
  "fun":"getBsConnectState",
  "dataTag":"1"
}
```
#### 事件
##### [sEvtBsConnectState](#sevtbsconnectstate)
参见基站连接变化系统通知

##### fEvtBsOnlineState
- **主题**: <span class="yellowFill">/basestation/multiBase/receive</span>
- **功能描述**：基站在线返回基站型号和基站SN
- **参数说明**

|参数名|类型|限制|非空|说明|
|-----|-----|-----|-----|-----|
|fun|string|-|是|事件类型|
|dataTag|string|-|否|数据包标识，不需要时可传空字符串|
|data|object|-|是|传送参数的对象|
|+baseModel|int||否|基站的型号码|
|+modelName|string||否|基站的型号名称|
|+version|string||否|基站固件版本|
|+baseSN|string||否|基站SN|

- **示例代码**
```json
//连接成功
{
    "fun":"fEvtBsOnlineState",
    "dataTag":"1",
    "data":{       
        "baseModel":218,
        "modelName":"B200",
        "version":"1.0.3",
        "baseSN":"2024041401"
    }
}
```

### 基站授时
#### 方法
##### timeSync
- **主题**：/client/{baseSN}/send
- **功能描述**：发送当前时间戳给基站进行校时
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|固定指令名称|
|dataTag|string|-|否|数据包标识|
|data|object|-|是|传送参数的对象|
|+timeStamp|long ||否|当前时间的时间戳|

- **示例代码**
```json
{
  "fun":"timeSync",
  "dataTag":"1",
  "data":{
      "timeStamp":1718247133290
  }
}
```
#### 事件
##### [sEvtStateCode](#sevtstatecode)
返回指令的接收状态

### 识别设置
#### 方法
<inner>

##### setBsSN
- **主题**：<sapn class="yellowFill">/manage/{baseSN}/send</span>
- **功能描述**：设置基站的SN，<font color="red">需预先订阅新SN的主题,以获取事件返回</font>
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识|
|data|object|-|是|传送参数的对象|
|+value|string|数字|是|设置的基站SN，长度为10位数字|
<!-- |+time|string|数字|是|时间，yyyyMMddHHmmss|
|+verCode|string||是|内部主题校验码，时间+固定key加密| -->

- **示例代码**
```json
{
    "fun":"setBsSN",
    "dataTag":"1",
    "data":{
        "value":"2024041201"
    }
}
```
</inner>

##### getBsModel
- **主题**：/client/{baseSN}/send
- **功能描述**：获取基站型号
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"getBsModel",
  "dataTag":"1"
}
```
##### getBsFWVersion
- **主题**：/client/{baseSN}/send
- **功能描述**：获取基站固件版本
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"getBsFWVersion",
  "dataTag":"1"
}

```

<inner>

##### getBsBIC
- **主题**：<sapn class="yellowFill">/manage/{baseSN}/send</span>
- **功能描述**：获取基站品牌识别码
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"getBsBIC",
  "dataTag":"1"
}
```

##### setBsBIC
- **主题**：<sapn class="yellowFill">/manage/{baseSN}/send</span>
- **功能描述**：设置基站品牌识别码
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+value|string||是|设置的基站品牌码|
<!-- |+time|string|数字|是|时间，yyyyMMddHHmmss|
|+verCode|string||是|内部主题校验码，时间+固定key加密| -->

- **示例代码**
```json
{
  "fun":"setBsBIC",
  "dataTag":"1",
  "data":{
    "value":"EA10"
  }
}
```
</inner>

#### 事件
##### fEvtBsSN
- **主题**: /basestation/{baseSN}/receive
- **功能描述**：返回基站的出厂编码
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|事件名称|
|dataTag|string|-|否|数据包标识|
|data|object|-|是|传送参数的对象|
|+value|string|-|是|基站的出厂编码|

- **示例代码**
```json
{
    "fun":"fEvtBsSN",
    "dataTag":"1",
    "data":{
        "value":"2024041201"
    }
}
```
##### fEvtBsModel
- **主题**: /basestation/{baseSN}/receive
- **功能描述**：返回基站的型号
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|事件名称|
|dataTag|string|-|否|数据包标识|
|data|object|-|是|传送参数的对象|
|+value|string|-|是|基站的型号名称|

- **示例代码**
```json
{
    "fun":"fEvtBsModel",
    "dataTag":"1",
    "data":{
        "value":"B200"
    }
}
```
##### fEvtBsFWVersion
- **主题**: /basestation/{baseSN}/receive
- **功能描述**：返回基站的固件版本
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|事件名称|
|dataTag|string|-|否|数据包标识|
|data|object|-|是|传送参数的对象|
|+value|string||是|基站的固件版本号|

- **示例代码**
```json
{
    "fun":"fEvtBsFWVersion",
    "dataTag":"1",
    "data":{
        "value":"1.0.3"
    }
}
```
<inner>

##### fEvtBsBIC
- **主题**: <sapn class="yellowFill">/manage/{baseSN}/receive</span>
- **功能描述**：返回基站的品牌码
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|事件名称|
|dataTag|string|-|否|数据包标识|
|data|object|-|是|传送参数的对象|
|+value|string||是|基站的品牌码<br>EA10: 中天电子<br>B001: 科大讯飞<br>B002: 台湾网奕<br>B003: 德国Infowhyse<br>B004: 印度K12 Techno<br>B005: 印度UOLO |

- **示例代码**
```json
{
    "fun":"fEvtBsBIC",
    "dataTag":"1",
    "data":{
        "value":"EA10"
    }
}
```
</inner>

### 组网设置
#### 方法
##### getBsNetworkMode
- **主题**：/client/{baseSN}/send
- **功能描述**：获取基站组网模式
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"getBsNetworkMode",
  "dataTag":"1"
}
```
<inner>

##### setBsNetworkMode
- **主题**：/client/{baseSN}/send
- **功能描述**：设置基站组网模式
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+value|string|-|是|设置的基站组网模式<br>1-配对模式<br>2-白名单模式|

- **示例代码**
```json
{
  "fun":"setBsNetworkMode",
  "dataTag":"1",
  "data":{
    "value":"1"
  }
}
```
</inner>

##### getBsPairCode
- **主题**：/client/{baseSN}/send
- **功能描述**：获取基站配对码
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"getBsPairCode",
  "dataTag":"1"
}
```
<inner>

##### setBsPairCode
- **主题**：<sapn class="yellowFill">/manage/{baseSN}/send</span>
- **功能描述**：设置基站配对码
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|否|传送参数的对象|
|+value|string|-|否|设置的基站配对码，8位数字|
<!-- |+time|string|数字|是|时间，yyyyMMddHHmmss|
|+verCode|string||是|内部主题校验码，时间+固定key加密| -->

- **示例代码**
```json
{
  "fun":"setBsPairCode",
  "dataTag":"1",
  "data":{
    "value":"04120101"
  }
}
```
</inner>

##### getBsNfcLogin
- **主题**：/client/{baseSN}/send
- **功能描述**：获取刷卡配对状态
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"getBsNfcLogin",
  "dataTag":"1"
}
```
##### setBsNfcLogin
- **主题**：/client/{baseSN}/send
- **功能描述**：设置基站刷卡配对状态
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+value|string|-|是|设置的基站刷卡配对状态<br>0-关闭刷卡配对<br>1-开启刷卡配对|

- **示例代码**
```json
{
  "fun":"setBsNfcLogin",
  "dataTag":"1",
  "data":{
    "value":"1"
  }
}
```
##### getBsChannel
- **主题**：/client/{baseSN}/send
- **功能描述**：获取基站信道
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"getBsChannel",
  "dataTag":"1"
}
```
##### setBsChannel
- **主题**：/client/{baseSN}/send
- **功能描述**：设置基站信道
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+value|string|-|是|设置的基站信道，可设范围：1-80|

- **示例代码**
```json
{
  "fun":"setBsChannel",
  "dataTag":"1",
  "data":{
    "value":"23"
  }
}
```

##### getBsRFIChannel
- **主题**：/client/{baseSN}/send
- **功能描述**：获取已被其他基站占用的信道
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"getBsRFIChannel",
  "dataTag":"1"
}
```

#### 事件
##### fEvtBsNetworkMode
- **主题**: /basestation/{baseSN}/receive
- **功能描述**：返回基站组网模式
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|事件名称|
|dataTag|string|-|否|数据包标识，可传空字符串|
|data|object|-|是|传送参数的对象|
|+value|string||是|基站的组网模式<br>1-配对模式<br>2-白名单模式|

- **示例代码**
```json
{
    "fun":"fEvtBsNetworkMode",
    "dataTag":"1",
    "data":{        
        "value":"1"
    }
}
```
##### fEvtBsPairCode
- **主题**: /basestation/{baseSN}/receive
- **功能描述**：返回基站配对码
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|事件名称|
|dataTag|string|-|否|数据包标识，可传空字符串|
|data|object|-|是|传送参数的对象|
|+value|string||是|基站的配对码|

- **示例代码**
```json
{
    "fun":"fEvtBsPairCode",
    "dataTag":"1",
    "data":{        
        "value":"12345678"
    }
}
```

##### fEvtBsChannel
- **主题**: /basestation/{baseSN}/receive
- **功能描述**：返回基站信道
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|事件名称|
|dataTag|string|-|否|数据包标识，可传空字符串|
|data|object|-|是|传送参数的对象|
|+value|string||是|基站信道|

- **示例代码**
```json
{
    "fun":"fEvtBsChannel",
    "dataTag":"1",
    "data":{        
        "value":"5"
    }
}
```

##### fEvtBsRFIChannel
- **主题**: /basestation/{baseSN}/receive
- **功能描述**：返回其他基站已占用的信道，频点冲突时，可以根据返回结果修改基站信道避开干扰
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|事件名称|
|dataTag|string|-|否|数据包标识，可传空字符串|
|data|object|-|是|传送参数的对象|
|+value|string||是|其他基站已占用的信道，多个信道用英文","分隔，无占用信道返回0|

- **示例代码**
```json
//信道1、2、14已被占用
{
    "fun":"fEvtBsRFIChannel",
    "dataTag":"1",
    "data":{        
        "value":"1,2,14"
    }
}
//无占用信道
{
    "fun":"fEvtBsRFIChannel",
    "dataTag":"1",
    "data":{        
        "value":"0"
    }
}
```

##### fEvtBsNfcLogin
- **主题**: /basestation/{baseSN}/receive
- **功能描述**：返回基站是否允许NFC刷卡
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|事件名称|
|dataTag|string|-|否|数据包标识，可传空字符串|
|data|object|-|是|传送参数的对象|
|+value|string||是|0-关闭  1-开启|

- **示例代码**
```json
{
    "fun":"fEvtBsNfcLogin",
    "dataTag":"1",
    "data":{        
        "value":"1"
    }
}
```
### 登录设置
#### 方法
##### getBsSSID
获取基站登录名称
- **主题**：/client/{baseSN}/send
- **功能描述**：获取基站登录名称
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|固定指令名称|
|dataTag|string|-|否|数据包标识|

- **示例代码**
```json
{
  "fun":"getBsSSID",
  "dataTag":"1"
}
```
##### setBsSSID
- **主题**：/client/{baseSN}/send
- **功能描述**：设置基站登录名称
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+value|string||是|设置的基站SSID，最长12字符|

- **示例代码**
```json
{
  "fun":"setBsSSID",
  "dataTag":"1",
  "data":{
    "value":"1901班"
  }
}
```
##### getBsLoginPwd
- **主题**：/client/{baseSN}/send
- **功能描述**：获取基站登录密码
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|固定指令名称|
|dataTag|string|-|否|数据包标识|

- **示例代码**
```json
{
  "fun":"getBsLoginPwd",
  "dataTag":"1"
}
```
##### setBsLoginPwd
- **主题**：/client/{baseSN}/send
- **功能描述**：设置基站登录密码
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+value|string||是|设置的基站登录密码，数字类型，最长4位，为空或设为0代表无需密码登录|

- **示例代码**
```json
{
  "fun":"setBsLoginPwd",
  "dataTag":"1",
  "data":{
    "value":"1234"
  }
}
```
##### getBsLoginState
获取基站登录名称
- **主题**：/client/{baseSN}/send
- **功能描述**：获取基站登录状态
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|固定指令名称|
|dataTag|string|-|否|数据包标识|

- **示例代码**
```json
{
  "fun":"getBsLoginState",
  "dataTag":"1"
}
```
##### setBsLoginState
- **主题**：/client/{baseSN}/send
- **功能描述**：设置基站登录状态
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+value|string||是|设置是否允许键盘自主登入<br>0 - 不允许键盘登入<br>1 - 允许键盘登入|

- **示例代码**
```json
{
  "fun":"setBsLoginState",
  "dataTag":"1",
  "data":{
    "value":"1"
  }
}
```

#### 事件
##### fEvtBsSSID
- **主题**: /basestation/{baseSN}/receive
- **功能描述**：返回基站名称
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|事件名称|
|dataTag|string|-|否|数据包标识，可传空字符串|
|data|object|-|是|传送参数的对象|
|+value|string||是|基站名称|

- **示例代码**
```json
{
    "fun":"fEvtBsSSID",
    "dataTag":"1",
    "data":{        
        "value":"1901班"
    }
}
```
##### fEvtBsLoginPwd
- **主题**: /basestation/{baseSN}/receive
- **功能描述**：返回基站登录密码
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|事件名称|
|dataTag|string|-|否|数据包标识，可传空字符串|
|data|object|-|是|传送参数的对象|
|+value|string||是|基站登录密码，返回值为0代表无需密码登录|

- **示例代码**
```json
{
    "fun":"fEvtBsLoginPwd",
    "dataTag":"1",
    "data":{        
        "value":"1234"
    }
}

//无需密码登录
{
    "fun":"fEvtBsLoginPwd",
    "dataTag":"1",
    "data":{        
        "value":"0"
    }
}
```
##### fEvtBsLoginState
- **主题**: /basestation/{baseSN}/receive
- **功能描述**：返回基站登录状态
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|事件名称|
|dataTag|string|-|否|数据包标识，可传空字符串|
|data|object|-|是|传送参数的对象|
|+value|string||是|基站登录状态|

- **示例代码**
```json
{
    "fun":"fEvtBsLoginState",
    "dataTag":"1",
    "data":{        
        "value":"1"
    }
}
```
### 键盘统一设置
#### 方法
##### getBsKpLanguage
- **主题**：/client/{baseSN}/send
- **功能描述**：获取键盘语言
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"getBsKpLanguage",
  "dataTag":"1"
}
```
##### setBsKpLanguage
- **主题**：/client/{baseSN}/send
- **功能描述**：设置键盘语言
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+value|string||是|设置键盘显示的语言<br>1-简体中文<br>2-英文|

- **示例代码**
```json
{
  "fun":"setBsKpLanguage",
  "dataTag":"1",
  "data":{
    "value":"1"
  }
}
```
##### getBsKpStbMsgMode
- **主题**：/client/{baseSN}/send
- **功能描述**：获取状态语设置状态
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"getBsKpStbMsgMode",
  "dataTag":"1"
}
```
##### setBsKpStbMsgMode
- **主题**：/client/{baseSN}/send
- **功能描述**：设置状态语工作状态
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+value|string||是|设置状态语工作状态<br>0-系统默认<br>1-用户内置|

- **示例代码**
```json
{
  "fun":"setBsKpStbMsgMode",
  "dataTag":"1",
  "data":{
    "value":"0"
  }
}
```
##### getBsKpLoginMenu
- **主题**：/client/{baseSN}/send
- **功能描述**：获取键盘登录菜单显示状态
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"getBsKpLoginMenu",
  "dataTag":"1"
}
```

##### setBsKpLoginMenu
- **主题**：/client/{baseSN}/send
- **功能描述**：设置键盘登录菜单显示状态
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+value|string||是|设置键盘登录菜单显示状态<br>0-不显示<br>1-显示|

- **示例代码**
```json
{
  "fun":"setBsKpLoginMenu",
  "dataTag":"1",
  "data":{
    "value":"1"
  }
}
```

##### getBsKpRFIDState
- **主题**：/client/{baseSN}/send
- **功能描述**：获取键盘长距离考勤开启状态
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"getBsKpRFIDState",
  "dataTag":"1"
}
```
##### setBsKpRFIDState
- **主题**：/client/{baseSN}/send
- **功能描述**：设置键盘长距离考勤开启状态
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+value|string||是|设置键盘长距离考勤开启状态<br>0-不开启<br>1-开启|

- **示例代码**
```json
{
  "fun":"setBsKpRFIDState",
  "dataTag":"1",
  "data":{
    "value":"1"
  }
}
```
<inner>

##### getBsKpSleepLevel
- **主题**：<sapn class="yellowFill">/manage/{baseSN}/send</span>
- **功能描述**：获取键盘休眠时间等级
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"getBsKpSleepLevel",
  "dataTag":"1"
}
```

##### setBsKpSleepLevel
- **主题**：<sapn class="yellowFill">/manage/{baseSN}/send</span>
- **功能描述**：设置键盘休眠时间等级
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+value|string||是|设置键盘休眠的时间等级<br>0-30秒<br>1-2分钟<br>2-10分钟<br>3-45分钟|

- **示例代码**
```json
{
  "fun":"setBsKpSleepLevel",
  "dataTag":"1",
  "data":{
    "value":"1"
  }
}
```

##### setBsKpPauseSleep
- **主题**：<sapn class="yellowFill">/manage/{baseSN}/send</span>
- **功能描述**：设置键盘暂停休眠是否开启<br><font color="red">注意：请谨慎使用本功能，务必在相关测试或功能完成后关闭，否则可能会导致键盘异常耗电<br>设置单次生效，基站拔插后复位成关闭状态</font>
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+value|string||是|设置键盘暂停休眠是否开启<br>0-关闭暂停休眠<br>1-开启暂停休眠|

- **示例代码**
```json
{
  "fun":"setBsKpPauseSleep",
  "dataTag":"1",
  "data":{
    "value":"1"
  }
}
```

##### getBsKpPauseSleep
- **主题**：<sapn class="yellowFill">/manage/{baseSN}/send</span>
- **功能描述**：获取键盘暂停休眠是否开启
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"getBsKpPauseSleep",
  "dataTag":"1"
}
```
</inner>

#### 事件
##### fEvtBsKpLanguage
- **主题**: /basestation/{baseSN}/receive
- **功能描述**：返回键盘语言
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+value|string||是|键盘显示的语言<br>1-简体中文<br>2-英文|

- **示例代码**
```json
{
  "fun":"fEvtBsKpLanguage",
  "dataTag":"1",
  "data":{
    "value":"1"
  }
}
```
##### fEvtBsKpStbMsgMode
- **主题**: /basestation/{baseSN}/receive
- **功能描述**：返回状态语工作状态
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+value|string||是|返回状态语工作状态<br>0-系统默认<br>1-用户内置|

- **示例代码**
```json
{
  "fun":"fEvtBsKpStbMsgMode",
  "dataTag":"1",
  "data":{
    "value":"0"
  }
}
```
##### fEvtBsKpLoginMenu
- **主题**: /basestation/{baseSN}/receive
- **功能描述**：返回键盘登录菜单显示状态
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+value|string||是|返回键盘登录菜单显示状态<br>0-不显示<br>1-显示|

- **示例代码**
```json
{
  "fun":"fEvtBsKpLoginMenu",
  "dataTag":"1",
  "data":{
    "value":"0"
  }
}
```

##### fEvtBsKpRFIDState
- **主题**: /basestation/{baseSN}/receive
- **功能描述**：返回键盘长距离考勤开启状态
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+value|string||是|返回键盘长距离考勤开启状态<br>0-不开启<br>1-开启|

- **示例代码**
```json
{
  "fun":"fEvtBsKpRFIDState",
  "dataTag":"1",
  "data":{
    "value":"0"
  }
}
```
<inner>

##### fEvtBsKpSleepLevel
- **主题**: <sapn class="yellowFill">/manage/{baseSN}/receive</span>
- **功能描述**：返回键盘休眠时间等级
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+value|string||是|键盘休眠的时间等级<br>0-30秒<br>1-2分钟<br>2-10分钟<br>3-45分钟|

- **示例代码**
```json
{
  "fun":"fEvtBsKpSleepLevel",
  "dataTag":"1",
  "data":{
    "value":"1"
  }
}
```

##### fEvtBsKpPauseSleep
- **主题**: <sapn class="yellowFill">/manage/{baseSN}/receive</span>
- **功能描述**：返回暂停键盘休眠开启状态
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+value|string||是|返回暂停键盘休眠开启状态<br>0-未开启暂停休眠<br>1-开启暂停休眠|

- **示例代码**
```json
{
  "fun":"fEvtBsKpPauseSleep",
  "dataTag":"1",
  "data":{
    "value":"0"
  }
}
```
</inner>

### 配对模式
#### 方法
##### startBsFastPair
- **主题**：/client/{baseSN}/send
- **功能描述**：启动快速配对,键盘配对成功返回键盘信息 [sEvtBsKpOnlineMsg](#sevtbskponlinemsg)
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"startBsFastPair",
  "dataTag":"1"
}
```
##### stopBsFastPair
- **主题**：/client/{baseSN}/send
- **功能描述**：停止快速配对
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"stopBsFastPair",
  "dataTag":"1"
}
```
#### 事件
##### [sEvtStateCode](#sevtstatecode)
发送指令后返回此事件

##### [sEvtBsKpOnlineMsg](#sevtbskponlinemsg)
键盘配对成功后在线返回此事件

### 白名单模式
#### 方法
##### getBsWhitelist
- **主题**：/client/{baseSN}/send
- **功能描述**：获取基站白名单列表
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"getBsWhitelist",
  "dataTag":"1"
}
```
##### setBsWhitelist
- **主题**：/client/{baseSN}/send
- **功能描述**：设置基站白名单列表，将基站白名单替换为写入的键盘SN列表
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+keySns|array|-|是|待写入的键盘SN数组，最多不超过200<br>键盘SN为10位数字|

- **示例代码**
```json
{
  "fun":"setBsWhitelist",
  "dataTag":"1",
  "data":{
    "keySns":["2024021001","2024021002","2024021003","2024021004"]
  }
}
```
##### clearBsWhitelist
- **主题**：/client/{baseSN}/send
- **功能描述**：清空基站白名单列表
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"clearBsWhitelist",
  "dataTag":"1"
}
```
##### addBsWhitelist
- **主题**：/client/{baseSN}/send
- **功能描述**：添加键盘至基站白名单列表
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+keySns|array|-|是|待添加的键盘SN列表<br>键盘SN为10位数字|

- **示例代码**
```json
{
  "fun":"addBsWhitelist",
  "dataTag":"1",
  "data":{
    "keySns":["2024021001"]
  }
}
```
##### delBsWhitelist
- **主题**：/client/{baseSN}/send
- **功能描述**：从基站白名单列表中删除键盘
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+keySns|array|-|是|待删除的键盘SN列表<br>键盘SN为10位数字|

- **示例代码**
```json
{
  "fun":"delBsWhitelist",
  "dataTag":"1",
  "data":{
    "keySns":["2024021001"]
  }
}
```
#### 事件
##### [sEvtStateCode](#sevtstatecode)
发送指令后返回此事件

##### fEvtBsWhitelist
- **主题**：/basestation/{baseSN}/receive
- **功能描述**：返回基站白名单列表
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+keySns|array||是|基站当前的白名单列表|

- **示例代码**
```json
{
  "fun":"fEvtBsWhitelist",
  "dataTag":"1",
  "data":{
    "keySns":["2024021001","2024021002","2024021003","2024021004"]
  }
}
```

##### fEvtSetBsWhitelist
- **主题**：/basestation/{baseSN}/receive
- **功能描述**：返回设置白名单状态
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|array|-|是|传送参数的对象数组|
|++keySns|array||是|键盘SN数组|
|++state|int||是|键盘SN的写入状态 <br>0-写入成功<br> 1-写入失败|

- **示例代码**
```json
{
  "fun":"fEvtSetBsWhitelist",
  "dataTag":"1",
  "data":[{
    "keySns":["2024021001","2024021002"],
    "state":0
  },{
    "keySns":["1211"],
    "state":1
  }]
}
```

##### fEvtAddBsWhitelist
- **主题**：/basestation/{baseSN}/receive
- **功能描述**：返回增加键盘状态
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|array|-|是|传送参数的对象数组|
|++keySns|array||是|键盘SN数组|
|++state|int||是|键盘的增加状态 <br>0-增加成功<br> 1-增加失败|

- **示例代码**
```json
{
  "fun":"fEvtAddBsWhitelist",
  "dataTag":"1",
  "data":[{
    "keySns":["2024021001","2024021002"],
    "state":0
  },{
    "keySns":["1211"],
    "state":1
  }]
}
```

##### fEvtDelBsWhitelist
- **主题**：/basestation/{baseSN}/receive
- **功能描述**：返回删除键盘状态
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|array|-|是|传送参数的对象数组|
|++keySns|array||是|键盘SN数组|
|++state|int||是|键盘的删除状态 <br>0-删除成功<br> 1-删除失败|

- **示例代码**
```json
{
  "fun":"fEvtDelBsWhitelist",
  "dataTag":"1",
  "data":[{
    "keySns":["2024021002"],
    "state":0
  },{
    "keySns":["2024021001"],
    "state":1
  }]
}
```

### 网络参数设置
#### 方法
##### getBsTcpipParams
- **主题**：/client/{baseSN}/send
- **功能描述**：获取基站TCP/IP参数
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"getBsTcpipParams",
  "dataTag":"1"
}
```
##### setBsTcpipParams
- **主题**：/client/{baseSN}/send
- **功能描述**：设置基站TCP/IP参数
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+ip|string||否|IP地址|
|+mask|string||否|子网掩码|
|+gateway|string||否|网关地址|
|+ipAllocation|int||否|基站IP获取方式<br>0 - 手动指定<br>1 - DHCP获取|

- **示例代码**
```json
{
  "fun":"setBsTcpipParams",
  "dataTag":"1",
  "data":{
    "ip":"192.168.0.10",
    "mask":"255.255.255.0",
    "gateway":"192.168.0.1",
    "ipAllocation":1
  }
}
```
##### getBsMqttParams
- **主题**：/client/{baseSN}/send
- **功能描述**：获取基站MQTT参数
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"getBsMqttParams",
  "dataTag":"1"
}
```
##### setBsMqttParams
- **主题**：/client/{baseSN}/send
- **功能描述**：设置基站MQTT参数
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+server|string||是|服务器IP地址|
|+port|int||是|端口，默认1883|
|+userName|string||否|连接服务器的用户名，可不设置|
|+password|string||否|连接服务器的密码，可不设置|
|+interval|int|>=30|否|基站连接服务器失败后重连的间隔时长，单位秒|

- **示例代码**
```json
{
  "fun":"setBsMqttParams",
  "dataTag":"1",
  "data":{
    "server":"192.168.10.10",
    "port":1883,
    "userName":"",
    "password":"",
    "interval":30
  }
}
```
#### 事件
##### fEvtBsTcpipParams
- **主题**: /basestation/{baseSN}/receive
- **功能描述**：返回基站TCP/IP参数
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+mac|string||是|MAC地址|
|+ip|string||是|IP地址|
|+mask|string||是|子网掩码|
|+gateway|string||是|网关地址|
|+ipAllocation|int||否|基站IP获取方式<br>0 - 手动指定<br>1 - DHCP获取|

- **示例代码**
```json
{
  "fun":"fEvtBsTcpipParams",
  "dataTag":"1",
  "data":{
    "mac":"FF:FF:FF:FF:FF:FF",
    "ip":"192.168.0.10",
    "mask":"255.255.255.0",
    "gateway":"192.168.0.1",
    "ipAllocation":1
  }
}
```
##### fEvtBsMqttParams
- **主题**: /basestation/{baseSN}/receive
- **功能描述**：返回基站MQTT参数
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+server|string||是|服务器地址，IP|
|+port|int||是|端口，默认1883|
|+userName|string||否|连接服务器的用户名，可不设置|
|+password|string||否|连接服务器的密码，可不设置|
|+interval|int||否|基站连接服务器失败后重连的间隔时长，单位秒|

- **示例代码**
```json
{
  "fun":"fEvtBsMqttParams",
  "dataTag":"1",
  "data":{
    "server":"192.168.10.10",
    "port":1883,
    "userName":"",
    "password":"",
    "interval":30
  }
}
```
### 基站加密
#### 方法
##### getBsSoftwareKey
- **主题**：/client/{baseSN}/send
- **功能描述**：获取基站软件狗密钥
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"getBsSoftwareKey",
  "dataTag":"1"
}
```
##### setBsSoftwareKey
- **主题**：/client/{baseSN}/send
- **功能描述**：设置基站软件狗密钥
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+value|string|-|是|基站软件狗密钥，长度不超过32字节|

- **示例代码**
```json
{
  "fun":"setBsSoftwareKey",
  "dataTag":"1",
  "data":{
    "value":"sunvote123456"
  }
}
```
#### 事件
##### fEvtBsSoftwareKey
- **主题**：/basestation/{baseSN}/receive
- **功能描述**：返回基站的软件狗密钥
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+value|string||是|返回基站的软件狗密钥|

- **示例代码**
```json
{
  "fun":"fEvtBsSoftwareKey",
  "dataTag":"1",
  "data":{
    "value":"sunvote123456"
  }
}
```
<inner>

### 基站维护
#### 方法
##### getBsLogInfo
- **主题**：<sapn class="yellowFill">/manage/{baseSN}/send</span>
- **功能描述**：获取基站日志,用于出现故障需要排查问题时获取基站内部日志记录
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"getBsLogInfo",
  "dataTag":"1"
}
```

##### clearBsLogInfo
- **主题**：<sapn class="yellowFill">/manage/{baseSN}/send</span>
- **功能描述**：清空基站内部日志记录
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"clearBsLogInfo",
  "dataTag":"1"
}
```

##### resetBsSystem
- **主题**：/client/{baseSN}/send
- **功能描述**：软复位基站<sapn class="yellowFill">（公共主题可用，但不体现在外部版本协议中</span>）
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"resetBsSystem",
  "dataTag":"1"
}
```

##### resetBsPower
- **主题**：/client/{baseSN}/send
- **功能描述**：断电复位基站<sapn class="yellowFill">（公共主题可用，但不体现在外部版本协议中）</span>
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"resetBsPower",
  "dataTag":"1"
}
```

##### startBsSelfCheck
- **主题**：<sapn class="yellowFill">/manage/{baseSN}/send</span>
- **功能描述**：开始基站自检,基站自检状态中不接收其他指令，空闲状态中才进入自检
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"startBsSelfCheck",
  "dataTag":"1"
}
```
#### 事件
##### [sEvtStateCode](#sevtstatecode)
返回指令的接收状态
注意：内部指令的接收状态需从**主题: <sapn class="yellowFill">/manage/{baseSN}/receive</span>** 返回

##### [sEvtBsConnectState](#sevtbsconnectstate)
复位基站后，基站重新连接成功后上报

##### fEvtBsLogInfo
- **主题**: <sapn class="yellowFill">/manage/{baseSN}/receive</span>
- **功能描述**：返回基站存储的日志内容
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+index|int||是|数据包序号，从1开始，传0代表日志已传完|
|+info|string||是|日志内容<br><font color="red">日志的时间依赖于基站授时，需要加上时区得到具体的时间</font>|

- **示例代码**
```json
{
  "fun":"fEvtBsLogInfo",
  "dataTag":"1",
  "data":{
    "index":1,
    "info":"XXXXXXXXXXXXX"
  }
}
```

##### fEvtBsSelfCheck
- **主题**: <sapn class="yellowFill">/manage/{baseSN}/receive</span>
- **功能描述**：返回基站自检的结果
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|array|-|是|传送参数的对象数组|
|++name|string||是|检测项名称：MCU、RF、FLASH、EEPROM|
|++state|int||是|检测结果<br>0-功能正常<br>1-功能异常|

- **示例代码**
```json
{
  "fun":"fEvtBsSelfCheck",
  "dataTag":"1",
  "data":[
    {
      "name":"MCU",
      "state":0
    },
    {
      "name":"RF",
      "state":0
    },
    {
      "name":"FLASH",
      "state":0
    },
    {
      "name":"EEPROM",
      "state":0
    }
  ]
}
```
### 基站升级
#### 方法
##### startBsUpdate
- **主题**：<sapn class="yellowFill">/manage/{baseSN}/send</span>
- **功能描述**:基站固件升级
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+partition|int||是|存储区域<br> 1-备份区<font class="yellowFill"> 使用备份区固件的方法：打开基站盖子，按住SW1按钮，上电后松开按钮，这时基站固件就会更新成备份区的固件</font><br>2-更新区，实时升级基站固件|
|+url|string||是|待升级的固件地址，可访问的网络url|
|+version|string||是|待升级的基站固件版本|
|+crc|uint||是|固件CRC校验码，10进制数字|
<!-- |+time|string||是|时间，yyyyMMddHHmmss|
|+verCode|string||是|内部主题校验码，时间+固定key加密| -->

- **示例代码**
```json
{
  "fun":"startBsUpdate",
  "dataTag":"1",
  "data":{
    "partition":2,
    "url":"http://192.168.10.10/V1.0.3.bin",
    "version":"1.0.3",
    "crc":1429319861
  }
}
```
##### downloadFontLib
- **主题**：<sapn class="yellowFill">/manage/{baseSN}/send</span>
- **功能描述**:下载更新基站字库文件
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+partition|int||是|存储区域<br> 1-备份区<br>2-更新区|
|+url|string||是|待下载的字库地址，可访问的网络url|
|+version|string||是|待升级的字库版本|
|+crc|int||是|字库CRC校验码，10进制数字|
<!-- |+time|string||是|时间，yyyyMMddHHmmss|
|+verCode|string||是|内部主题校验码，时间+固定key加密| -->

- **示例代码**
```json
{
  "fun":"downloadFontLib",
  "dataTag":"1",
  "data":{
    "partition":2,
    "url":"http://192.168.10.10/V1.0.3.bin",
    "version":"1.0.3",
    "crc":1429319861
  }
}
```

#### 事件
##### [sEvtStateCode](#sevtstatecode)
返回升级指令的接收状态
注意：升级指令的接收状态需从**主题: <sapn class="yellowFill">/manage/{baseSN}/receive</span>** 返回

##### fEvtBsUpateState
- **主题**: <sapn class="yellowFill">/manage/{baseSN}/receive</span>
- **功能描述**：返回基站启动升级状态
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+state|int||是|启动升级状态<br>0 - 准备升级<br>1 - 升级成功<br>2 - 升级失败
|+msg|string||否|返回的失败原因

- **示例代码**
```json
{
  "fun":"fEvtBsUpateState",
  "dataTag":"1",
  "data":{
    "state":2,
    "msg":"error msg"
  }
}
```

##### fEvtBsUpdateProgress
- **主题**: <sapn class="yellowFill">/manage/{baseSN}/receive</span>
- **功能描述**：返回基站升级进度
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+progress|int||是|升级进度，百分比|

- **示例代码**
```json
{
  "fun":"fEvtBsUpdateProgress",
  "dataTag":"1",
  "data":{
    "progress":20
  }
}
```

##### fEvtBsFontLibState
- **主题**: <sapn class="yellowFill">/manage/{baseSN}/receive</span>
- **功能描述**：返回基站下载字库状态
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+state|int||是|启动升级状态<br>0 - 准备下载<br>1 - 下载完成<br>2 - 下载失败
|+msg|string||否|返回的失败原因

- **示例代码**
```json
{
  "fun":"fEvtBsFontLibState",
  "dataTag":"1",
  "data":{
    "state":2,
    "msg":"error msg"
  }
}
```

##### fEvtBsFontLibProgress
- **主题**: <sapn class="yellowFill">/manage/{baseSN}/receive</span>
- **功能描述**：返回基站下载字库进度
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+progress|int||是|下载进度，百分比|

- **示例代码**
```json
{
  "fun":"fEvtBsFontLibProgress",
  "dataTag":"1",
  "data":{
    "progress":20
  }
}
```
</inner>

## 键盘管理

<inner>

### 识别设置
#### 方法
##### setKpSN
- **主题**：<sapn class="yellowFill">/manage/{baseSN}/send</span>
- **功能描述**:设置指定键盘的出厂编码
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+oldKeySn|string||是|键盘原SN|
|+newKeySn|string||是|待设置的新SN|
|+time|string|数字|是|时间，yyyyMMddHHmmss|
|+verCode|string||是|内部主题校验码，时间+固定key加密|

- **示例代码**
```json
{
  "fun":"setKpSN",
  "dataTag":"1",
  "data":{
    "oldKeySn":"1234567890",
    "newKeySn":"2024021011"
  }
}
```

##### setKpID
- **主题**：<sapn class="yellowFill">/manage/{baseSN}/send</span>
- **功能描述**：设置键盘编号
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+keySn|string||是|需设置编号的键盘SN|
|+keyId|int||是|键盘编号，不超过65535|
- **示例代码**
```json
{
  "fun":"setKpID",
  "dataTag":"1",
  "data":{
    "keySn":"2024021011",
    "keyId":1
  }
}
```

##### startGetKpInfo
- **主题**：<sapn class="yellowFill">/manage/{baseSN}/send</span>
- **功能描述**：开始获取键盘信息
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|

- **示例代码**
```json
{
  "fun":"startGetKpInfo",
  "dataTag":"1"
}
```

##### stopGetKpInfo
- **主题**：<sapn class="yellowFill">/manage/{baseSN}/send</span>
- **功能描述**：停止获取键盘信息
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|

- **示例代码**
```json
{
  "fun":"stopGetKpInfo",
  "dataTag":"1"
}
```

#### 事件
##### [sEvtStateCode](#sevtstatecode)
发送指令后返回接收状态

##### fEvtSetKpSN
- **主题**：<sapn class="yellowFill">/manage/{baseSN}/receive</span>
- **功能描述**：返回写键盘SN状态
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+keySn|string||是|设置键盘SN的原SN|
|+state|string||是|设置是否成功<br>0-设置成功<br>1-设置失败|

- **示例代码**
```json
{
  "fun":"fEvtSetKpSN",
  "dataTag":"1",
  "data":{
    "keySn":"1234567890",
    "state":"0"
  }
}
```
##### fEvtSetKpID
- **主题**：<sapn class="yellowFill">/manage/{baseSN}/receive</span>
- **功能描述**：返回键盘编号
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+keySn|string||是|设置键盘id的键盘SN|
|+state|string||是|设置是否成功<br>0-设置成功<br>1-设置失败|

- **示例代码**
```json
{
  "fun":"fEvtSetKpID",
  "dataTag":"1",
  "data":{
    "keySn":"2024021011",
    "state":"0"
  }
}
```
##### fEvtKpInfo
- **主题**：<sapn class="yellowFill">/manage/{baseSN}/receive</span>
- **功能描述**：返回键盘信息
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+keySn|string||是|键盘SN|
|+keyId|int||是|键盘Id|
|+model|int||是|键盘型号代码|
|+version|string||是|键盘固件版本|

- **示例代码**
```json
{
  "fun":"fEvtKpInfo",
  "dataTag":"1",
  "data":{
    "keySn":"2024021011",
    "keyId":1,
    "model":67,
    "version":"1.0.0"
  }
}
```
</inner>

### 交互设置
#### 方法
##### setKpUserStbMsg
- **主题**：/client/{baseSN}/send
- **功能描述**：设置用户内置状态语
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+online|string||是|在线状态显示的待机语<br>空字符串清除|
|+offline|string||是|离线状态显示的待机语<br>空字符串清除|
|+submitting|string||是|提交中状态语<br>空字符串清除|
|+submitted|string||是|已提交状态语<br>空字符串清除|

- **示例代码**
```json
{
  "fun":"setKpUserStbMsg",
  "dataTag":"1",
  "data":{
    "online":"请认真听讲",
    "offline":"离线",
    "submitting":"提交中",
    "submitted":"提交成功"
  }
}
```
##### rtSetKpUserPrompt
- **主题**：/client/{baseSN}/send
- **功能描述**：实时设置提示反馈信息
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|array|-|否|传送参数的对象数组|
|++keySns|array||是|指定的键盘SN数组，空数组表示全部在线键盘<br><font color="red">注意：不允许空数组和指定SN数组混合使用<br>包含空数组默认为全部在线键盘，其他指定键盘无效</font>|
|++info|string||否|设置的反馈信息<br>不同键盘可设置不同反馈信息|

- **示例代码**

```json
//分别提示
{
  "fun":"rtSetKpUserPrompt",
  "dataTag":"1",
  "data": [
    {
      "keySns": ["1479824643","1479824645"],
      "info": "答对了"
    },
    {
      "keySns": ["1479824644"],
      "info": "答错了"
    }
  ]
}
//统一提示
{
  "fun":"rtSetKpUserPrompt",
  "dataTag":"1",
  "data": [
    {
      "keySns": [],
      "info": "答题结束"
    }
  ]
}
```
#### 事件
##### [sEvtStateCode](#sevtstatecode)
发送指令后返回接收状态

##### fEvtKpUserStbMsg
- **主题**：/basestation/{baseSN}/receive
- **功能描述**：返回设置状态语的状态
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|否|传送参数的对象|
|+state|string||是|设置状态语是否成功<br> 0 - 成功<br> 1 - 失败|

- **示例代码**
```json
{
  "fun":"fEvtKpUserStbMsg",
  "dataTag":"1",
  "data":{
    "state":"0"
  }
}
```
##### fEvtSetKpUserPrompt
- **主题**：/basestation/{baseSN}/receive
- **功能描述**：返回实时设置提示语是否成功
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|array|-|是|传送参数的对象数组|
|++keySn|string||是|设置提示语信息的键盘SN|
|++state|string||是|设置的提示语是否成功<br>0 - 成功<br>1 - 超时失败<br>2 - 参数错误|

- **示例代码**

```json
{
  "fun":"fEvtSetKpUserPrompt",
  "dataTag":"1",
  "data": [
    {
      "keySn": "1479824643",
      "state": "0"
    },
    {
      "keySn": "1479824645",
      "state": "0"
    },
    {
      "keySn": "1479824644",
      "state": "1"
    }
  ]
}
```
### 在线状态
#### 方法
##### startGetKpOnline
- **主题**：/client/{baseSN}/send
- **功能描述**：开始获取键盘在线信息,键盘在线返回键盘信息
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**

```json
{
  "fun":"startGetKpOnline",
  "dataTag":"1"
}
```

##### stopGetKpOnline
- **主题**：/client/{baseSN}/send
- **功能描述**：停止获取键盘在线信息
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**

```json
{
  "fun":"stopGetKpOnline",
  "dataTag":"1"
}
```

##### rtGetKpOnlineList
- **主题**：/client/{baseSN}/send
- **功能描述**：实时获取基站存储的键盘在线列表
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**

```json
{
  "fun":"rtGetKpOnlineList",
  "dataTag":"1"
}
```

#### 事件
##### [sEvtStateCode](#sevtstatecode)
发送指令后返回此事件

##### [sEvtBsKpOnlineList](#sevtbskponlinelist)
实时获取基站存储的键盘在线列表时返回此事件

##### fEvtKpOnlineMsg
- **主题**: /basestation/{baseSN}/receive
- **功能描述**：主动获取在线键盘时，在线键盘状态报告
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|事件名称|
|dataTag|string|-|否|数据包标识|
|data|object|-|是|传送参数的对象|
|+keySn|string||是|键盘SN|
|+version|string||是|键盘固件版本|
|+model|int||是|键盘型号|
|+voltage|double||是|键盘电量<inner><font color="red">（待键盘修改成百分比）</font></inner>|

- **示例代码**
```json
{
    "fun":"fEvtKpOnlineMsg",
    "dataTag":"1",
    "data":{ 
        "keySn":"1234567890",
        "version":"1.0.0",
        "model":67,
        "voltage":2.8
    }
}
```

### 维护功能
#### 方法
##### remoteKpSleep
- **主题**：/client/{baseSN}/send
- **功能描述**：遥控键盘休眠
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象数组|
|+keySns|array||否|需要执行指令的键盘SN数组，空数组表示所有键盘|

- **示例代码**
```json
{
  "fun":"remoteKpSleep",
  "dataTag":"1",
  "data":{
    "keySns":["1479824644"]
  }
}
```
<inner>

##### startKpFWUpdate
- **主题**：<sapn class="yellowFill">/manage/{baseSN}/send</span>
- **功能描述**:键盘升级
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+partition|int||是|存储区域<br> 1-备份区<br>2-更新区|
|+url|string||是|待升级的固件地址，可访问的网络url|
|+version|string||是|待升级的固件版本号|
|+crc|uint||是|固件CRC校验码,10进制数字|
<!-- |+time|string|数字|是|时间，yyyyMMddHHmmss|
|+verCode|string||是|内部主题校验码，时间+固定key加密| -->

- **示例代码**
```json
{
  "fun":"startKpFWUpdate",
  "dataTag":"1",
  "data":{
    "partition":2,
    "url":"http://192.168.10.10/V1.0.3.bin",
    "version":"1.0.3",
    "crc":1429319861
  }
}
```
##### stopKpFWUpdate
- **主题**：<sapn class="yellowFill">/manage/{baseSN}/send</span>
- **功能描述**:停止键盘升级
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
<!-- |+time|string|数字|是|时间，yyyyMMddHHmmss|
|+verCode|string||是|内部主题校验码，时间+固定key加密| -->

- **示例代码**
```json
{
  "fun":"stopKpFWUpdate",
  "dataTag":"1"
}
```
##### resetKpDefault
- **主题**：<sapn class="yellowFill">/manage/{baseSN}/send</span>
- **功能描述**:恢复键盘出厂设置
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
<!-- |+time|string|数字|是|时间，yyyyMMddHHmmss|
|+verCode|string||是|内部主题校验码，时间+固定key加密| -->

- **示例代码**
```json
{
  "fun":"resetKpDefault",
  "dataTag":"1"
}
```
</inner>

#### 事件
##### [sEvtStateCode](#sevtstatecode)
返回指令的接收状态
<inner>
注意：升级指令的接收状态需从**主题: <sapn class="yellowFill">/manage/{baseSN}/receive</span>** 返回

##### fEvtKpFWUpdateState
- **主题**: <sapn class="yellowFill">/manage/{baseSN}/receive</span>
- **功能描述**：返回键盘升级状态
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+state|int||是|升级状态<br>0 - 进入升级<br>1 - 升级成功 <br> 2 - 升级失败 <br> 3 - 已停止(接收到停止指令)
|+msg|string||否|返回的失败原因

- **示例代码**
```json
{
  "fun":"fEvtKpFWUpdateState",
  "dataTag":"1",
  "data":{
    "state":0,
    "msg":""
  }
}
```
##### fEvtKpUpdateProgress
- **主题**: <sapn class="yellowFill">/manage/{baseSN}/receive</span>
- **功能描述**：返回键盘升级进度
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+progress|int||是|升级进度，百分比|

- **示例代码**
```json
{
  "fun":"fEvtKpUpdateProgress",
  "dataTag":"1",
  "data":{
    "progress":20
  }
}
```
</inner>

## 绑定
### 无线绑定
#### 方法
##### rtSetKpBindingInfo
- **主题**：/client/{baseSN}/send
- **功能描述**：实时设置绑定信息到键盘
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|array|-|是|传送参数的对象数组，不可为空|
|++keySn|string||是|需要设置绑定信息的键盘SN|
|++info|string||是|设置的绑定信息，一般为学生姓名<br>最长48个字符，显示在键盘左上角|

- **示例代码**

```json
{
  "fun":"rtSetKpBindingInfo",
  "dataTag":"1",
  "data": [
    {
      "keySn": "1479824643",
      "info": "张三"
    },
    {
      "keySn": "1479824644",
      "info": "李四"
    }
  ]
}
```

##### clearKpBindingInfo
- **主题**：/client/{baseSN}/send
- **功能描述**：清除键盘绑定信息
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象数组|
|+keySns|array||否|需要清除绑定信息键盘SN数组，<br>空数组表示清空所有键盘|

- **示例代码**

```json
{
  "fun":"clearKpBindingInfo",
  "dataTag":"1",
  "data": {
    "keySns":["1479824643","1479824644","1479824645"]
  }
}
```
#### 事件
##### [sEvtStateCode](#sevtstatecode)
发送指令后返回接收状态

##### fEvtKpBindingInfo
- **主题**：/basestation/{baseSN}/receive
- **功能描述**：返回键盘实时设置绑定信息的状态是否成功
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|array|-|否|传送参数的对象数组|
|++keySn|string||是|需要设置绑定信息的键盘SN|
|++state|string||是|设置的绑定信息是否成功<br>0 - 成功<br>1 - 超时失败<br>2 - 参数错误|

- **示例代码**

```json
{
  "fun":"fEvtKpBindingInfo",
  "dataTag":"1",
  "data": [
    {
      "keySn": "1479824643",
      "state": "0"
    },
    {
      "keySn": "1479824644",
      "state": "1"
    }
  ]
}
```
##### fEvtClearKpBindingInfo
- **主题**：/basestation/{baseSN}/receive
- **功能描述**：返回清空绑定信息的指令状态是否成功
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|否|传送参数的对象|
|+state|string||是|设置的绑定信息是否成功<br>0 - 成功<br>1 - 失败|

- **示例代码**

```json
{
  "fun":"fEvtClearKpBindingInfo",
  "dataTag":"1",
  "data": {
    "state": "0"
  }
}
```
## 签到
### 同步签到
#### 方法
##### startKpSignIn
- **主题**：/client/{baseSN}/send
- **功能描述**：启动同步签到
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传递参数的对象|
|+mode|int|-|是|签到模式<br>1-按键签到，可指定按键<br>2-PIN码签到，可指定PIN码长度<inner><br>3-指纹签到(<font color="red">暂不支持</font>)</inner>|
|+allowModify |int|-|是 | 修改模式 <br> 0-不可修改 <br>1-可以修改(默认值)|
|+pinLen |int|-|是| 可输入pin码的最大长度 1≤N≤14 |
|+keyValue |int|-|是 | 指定按键键值 <br> 0: 未指定(OK键签到) <br>1-9: 按键1-9 <br> 10: 按键0 <br> 11: 上键  <br> 12: 下键 <br> 13: OK键  <br> 14: ESC键  <br> 15: Menu键 |
|+tip |string|-|否| 提示标题,长度最多不超过16个字节|

- **示例代码**
```json
//按键签到
{
  "fun":"startKpSignIn",
  "dataTag":"1",
  "data":{
    "mode":1,
    "allowModify":1,
    "keyValue":5,
    "tip":"请按5键签到"
  }
}

//pin签到
{
  "fun":"startKpSignIn",
  "dataTag":"1",
  "data":{
    "mode":2,
    "allowModify":1,
    "pinLen":6,
    "tip":"请输入PIN码签到"
  }
}
```
<!-- ##### stopKpSignIn
- **主题**：/client/{baseSN}/send
- **功能描述**：停止同步签到
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"stopKpSignIn",
  "dataTag":"1"
}
``` -->
##### [stopKpVote](#stopkpvote)
停止同步签到

#### 事件
##### [sEvtStateCode](#sevtstatecode)
发送指令后返回接收状态

##### [fEvtKpSignIn](#fevtkpsignin)
返回键盘提交的签到数据

### 随时签到
#### 方法
##### rtStartKpSignIn
- **主题**：/client/{baseSN}/send
- **功能描述**：启动随时签到绑定
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传递参数的对象|
|+mode|int|-|是|签到模式<inner><br>1-按键签到，按OK键签到自动授权(<font color="red">暂不支持</font>)</inner><br>2-PIN码签到，输入pin码后由应用程序决定是否授权|

- **示例代码**

```json
{
  "fun":"rtStartKpSignIn",
  "dataTag":"1",
  "data":{
    "mode":2
  }
}
```
##### rtStopKpSignIn
- **主题**：/client/{baseSN}/send
- **功能描述**：停止随时签到绑定
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**

```json
{
  "fun":"rtStopKpSignIn",
  "dataTag":"1"
}
```
##### rtSetKpLoginAllowed
- **主题**：/client/{baseSN}/send
- **功能描述**：实时PIN绑定授权,可取消授权
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传递参数的对象|
|+keySn|string|-|是|键盘SN|
|+state|int|-|是|1-授权成功<br>2-授权失败<br>3-解除已授权|

- **示例代码**

```json
{
  "fun":"rtSetKpLoginAllowed",
  "dataTag":"1",
  "data":{
    "keySn":"1479824643",
    "state":1
  }
}
```
#### 事件
##### [sEvtStateCode](#sevtstatecode)
发送指令后返回接收状态

##### fEvtKpSignIn
- **主题**：/basestation/{baseSN}/receive
- **功能描述**：返回键盘提交签到信息
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|array|-|是|传送参数的对象数组|
|++keySn|string||是|键盘SN|
|++keyValue|string||是|键盘提交的按键值|
|++keyTime|double||是|答题时间，从启动开始计算，单位秒|
|++voltage|double||是|键盘电量|
|++retryCount|int||是|键盘提交数据的重发次数|

- **示例代码**

```json
{
  "fun":"fEvtKpSignIn",
  "dataTag":"1",
  "data": [{
      "keySn": "1234567890",
      "keyValue":"1004",
      "keyTime":30.2
    },
    {
      "keySn": "1234567891",
      "keyValue":"1003",
      "keyTime":32.5
    }
  ]
}
```
##### fEvtKpLoginAllowed
- **主题**：/basestation/{baseSN}/receive
- **功能描述**：返回键盘授权状态
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+keySn|string||是|键盘SN|
|+state|string||是|0-执行成功<br> 1-执行失败|

- **示例代码**

```json
{
  "fun":"fEvtKpLoginAllowed",
  "dataTag":"1",
  "data": {
      "keySn":"1479824643",
      "state":"0"
    }
}
```
## 按键反馈
### 判断题
#### 方法
##### startQATrueFalse
- **主题**：/client/{baseSN}/send
- **功能描述**：启动判断题答题
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+keySns|array||是|指定的键盘SN数组，空数组表示全部在线键盘|
|+count|int||是|题目数量，1-16，>1多题快答|
|+mode|int||是|1 - True/False 对/错 <br>2 - Yes/No 是/否<br> 3 - √/×|
|+allowModify|int||是|0 - 不允许修改<br>1 - 允许修改|
|+tip|string||否|提示的标题，长度不超过16字符|<inner>
|+simParams|object||否|内部模拟测试参数设置对象|
|++answer|string||是|预设提交的按键值<br>1-对 <br>2-错|</inner>

- **示例代码**

```json
{
  "fun":"startQATrueFalse",
  "dataTag":"1",
  "data":{
    "keySns":[],
    "count":1,
    "mode":1,
    "allowModify":1,
    "tip":"请判断对错"
  }
}
```
<!-- ##### stopQATrueFalse
- **主题**：/client/{baseSN}/send
- **功能描述**：停止判断题答题
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**

```json
{
  "fun":"stopQATrueFalse",
  "dataTag":"1"
}
``` -->

##### [stopKpVote](#stopkpvote)
停止判断题答题

#### 事件
##### [sEvtStateCode](#sevtstatecode)
发送指令后返回接收状态

##### fEvtQATrueFalse
- **主题**：/basestation/{baseSN}/receive
- **功能描述**：返回键盘提交答题信息
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|array|-|是|传送参数的对象数组|
|++keySn|string||是|键盘SN|
|++keyValue|string||是|键盘提交的按键值<br>1-对<br>2-错|
|++keyTime|double||是|答题时间，从启动开始计算，单位秒|
|++voltage|double||是|键盘电量|
|++retryCount|int||是|键盘提交数据的重发次数|

- **示例代码**

```json
{
  "fun":"fEvtQATrueFalse",
  "dataTag":"1",
  "data": [{
      "keySn": "1234567890",
      "keyValue":"1",
      "keyTime":30.2
    }
  ]
}
```
### 选择题
#### 方法
##### startQAChoice
- **主题**：/client/{baseSN}/send
- **功能描述**：启动选择题答题
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+keySns|array||是|指定的键盘SN数组，空数组表示全部在线键盘|
|+count|int||是|题目数量，1-16，>1多题快答<br><font color="red">注意：多题快答只适用于单选题，count>1时optionalN 默认为1，且options需 >1，显示模式mode默认为1</font>|
|+mode|int||是|显示模式<br>1:显示字母(默认值) </br>2:显示数字 |
|+lessMode|int||是|迫选模式<br>0:可缺选(默认值) </br>1:不可缺选</br>2:允许重复输入</br>3:允许重复输入且不可缺选 |
|+options|int||是|选项数量，1≤M≤10(默认值4)|
|+optionalN|int||是|可选项个数，1≤N≤M(默认值1)|
|+allowModify|int||是|修改模式<br>0 - 不允许修改<br>1 - 允许修改|
|+tip|string||否|提示的标题，长度不超过16字符|<inner>
|+simParams|object||否|内部模拟测试参数设置对象|
|++answer|string||是|预设提交的按键值|</inner>

- **示例代码**

```json
{
  "fun":"startQAChoice",
  "dataTag":"1",
  "data":{
    "keySns":[],
    "mode": 1,
    "count":1,
    "lessMode": 0,
    "options": 4,
    "optionalN": 1,
    "allowModify":1,
    "tip":"请选择"
  }
}
```
<!-- ##### stopQAChoice
- **主题**：/client/{baseSN}/send
- **功能描述**：停止选择题答题
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**

```json
{
  "fun":"stopQAChoice",
  "dataTag":"1"
}
``` -->
##### [stopKpVote](#stopkpvote)
停止选择题答题

#### 事件
##### [sEvtStateCode](#sevtstatecode)
发送指令后返回接收状态

##### fEvtQAChoice
- **主题**：/basestation/{baseSN}/receive
- **功能描述**：返回键盘提交答题信息
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|array|-|是|传送参数的对象数组|
|++keySn|string||是|键盘SN|
|++keyValue|string||是|键盘提交的按键值|
|++keyTime|double||是|答题时间，从启动开始计算，单位秒|
|++voltage|double||是|键盘电量|
|++retryCount|int||是|键盘提交数据的重发次数|

- **示例代码**

```json
{
  "fun":"fEvtQAChoice",
  "dataTag":"1",
  "data": [{
      "keySn": "1234567890",
      "keyValue":"A",
      "keyTime":3.2
    }]
}
```
### 数字题
#### 方法
##### startQANum
- **主题**：/client/{baseSN}/send
- **功能描述**：启动数字题答题
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+keySns|array||是|指定的键盘SN数组，空数组表示全部在线键盘|
|+mode|int||是|模式<br>0:无规则 （S6最多16位，T2最多14位）<br>1:带小数位上下限（T2不支持）|
|+digits|int||是|小数位数,范围0-2，mode=1时有效
|+numMin|int||是|可输入下限,mode=1有效，范围0-100|
|+numMax|int||是|可输入上限,mode=1有效，范围0-100|
|+allowModify|int||是|修改模式<br>0 - 不允许修改<br>1 - 允许修改|
|+tip|string||否|提示的标题，长度不超过16字符|<inner>
|+simParams|object||否|内部模拟测试参数设置对象|
|++answer|string||是|预设提交的按键值|</inner>

- **示例代码**

```json
{
  "fun":"startQANum",
  "dataTag":"1",
  "data":{
    "keySns":[],
    "mode": 1,
    "digits": 1,
    "numMin": 0,
    "numMax": 100,
    "allowModify":1,
    "tip":"请输入数字"
  }
}
```
<!-- ##### stopQANum
- **主题**：/client/{baseSN}/send
- **功能描述**：停止数字题答题
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**

```json
{
  "fun":"stopQANum",
  "dataTag":"1"
}
``` -->
##### [stopKpVote](#stopkpvote)
停止数字题答题

#### 事件
##### [sEvtStateCode](#sevtstatecode)
发送指令后返回接收状态

##### fEvtQANum
- **主题**：/basestation/{baseSN}/receive
- **功能描述**：返回键盘提交答题信息
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|array|-|是|传送参数的对象数组|
|++keySn|string||是|键盘SN|
|++keyValue|string||是|键盘提交的按键值|
|++keyTime|double||是|答题时间，从启动开始计算，单位秒|
|++voltage|double||是|键盘电量|
|++retryCount|int||是|键盘提交数据的重发次数|

- **示例代码**

```json
{
  "fun":"fEvtQANum",
  "dataTag":"1",
  "data":[{
      "keySn": "1234567890",
      "keyValue":"10",
      "keyTime":3.2
    }]
}
```
### 抢答题
#### 方法
##### startQAQuicker
- **主题**：/client/{baseSN}/send
- **功能描述**：启动抢答题答题
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+keySns|array||是|指定的键盘SN数组，空数组表示全部在线键盘|
|+mode|int||是|模式<br>0:普通抢答|
|+allowModify|int||是|修改模式<br>0 - 不允许修改<br>1 - 允许修改|
|+tip|string||否|提示的标题，长度不超过16字符|<inner>
|+simParams|object||否|内部模拟测试参数设置对象|
|++answer|string||是|预设提交的按键值|</inner>

- **示例代码**
```json
{
  "fun":"startQAQuicker",
  "dataTag":"1",
  "data":{
    "keySns":[],
    "mode": 0,
    "allowModify":1,
    "tip":"请按键抢答"
  }
}
```
<!-- ##### stopQAQuicker
- **主题**：/client/{baseSN}/send
- **功能描述**：停止抢答答题
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**

```json
{
  "fun":"stopQAQuicker",
  "dataTag":"1"
}
``` -->

##### [stopKpVote](#stopkpvote)
停止抢答

#### 事件
##### [sEvtStateCode](#sevtstatecode)
发送指令后返回接收状态

##### fEvtQAQuicker
- **主题**：/basestation/{baseSN}/receive
- **功能描述**：返回键盘提交答题信息
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|array|-|是|传送参数的对象数组|
|++keySn|string||是|键盘SN|
|++keyValue|string||是|键盘提交的按键值|
|++keyTime|double||是|答题时间，从启动开始计算，单位秒|
|++voltage|double||是|键盘电量|
|++retryCount|int||是|键盘提交数据的重发次数|

- **示例代码**

```json
{
  "fun":"fEvtQAQuicker",
  "dataTag":"1",
  "data": [{
      "keySn": "1234567890",
      "keyValue":"1",
      "keyTime":3.2
    }]
}
```
### 文本题
#### 方法
##### startQAEText
- **主题**：/client/{baseSN}/send
- **功能描述**：启动文本题答题
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+keySns|array||是|指定的键盘SN数组，空数组表示全部在线键盘|
|+mode|int||是|模式<br>1:自由输入，最多不超过144字符|
|+allowModify|int||是|修改模式<br>0 - 不允许修改<br>1 - 允许修改|<inner>
|+simParams|object||否|内部模拟测试参数设置对象|
|++answer|string||是|预设提交的按键值|</inner>

- **示例代码**
```json
{
  "fun":"startQAEText",
  "dataTag":"1",
  "data":{
    "keySns":[],
    "mode": 1,
    "allowModify":1
  }
}
```
<!--##### stopQAEText
- **主题**：/client/{baseSN}/send
- **功能描述**：停止文本题答题
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"stopQAEText",
  "dataTag":"1"
}
```-->

##### [stopKpVote](#stopkpvote)
停止文本题答题

#### 事件
##### [sEvtStateCode](#sevtstatecode)
发送指令后返回接收状态

##### fEvtQAEText
- **主题**：/basestation/{baseSN}/receive
- **功能描述**：返回键盘提交答题信息
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|array|-|是|传送参数的对象数组|
|++keySn|string||是|键盘SN|
|++keyValue|string||是|键盘提交的按键值|
|++keyTime|double||是|答题时间，从启动开始计算，单位秒|

- **示例代码**
```json
{
  "fun":"fEvtQAEText",
  "dataTag":"1",
  "data": [{
      "keySn": "1234567890",
      "keyValue":"hello",
      "keyTime":3.2
    }]
}
```

### 短信息
#### 方法
##### sendKpMsg
- **主题**：/client/{baseSN}/send
- **功能描述**：指定键盘发送短信息
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|array|-|是|传送参数的对象数组，不可为空|
|++keySn|string||是|需要设置绑定信息的键盘SN<br>空字符串且只有一条信息时代表群发所有在线键盘|
|++month|int||是|月份，范围1-12|
|++day|int||是|日期,范围1-31|
|++info|string||是|信息内容|

- **示例代码**
```json
//指定键盘发送信息
{
  "fun":"sendKpMsg",
  "dataTag":"1",
  "data": [
    {
      "keySn": "1479824643",
      "month":6,
      "day":10,
      "info": "短信息1"
    },
    {
      "keySn": "1479824644",
      "month":6,
      "day":10,
      "info": "短信息2"
    }
  ]
}

//广播信息
{
  "fun":"sendKpMsg",
  "dataTag":"1",
  "data": [
    {
      "keySn": "",
      "month":6,
      "day":10,
      "info": "广播信息"
    }
  ]
}
```

#### 事件
##### [sEvtStateCode](#sevtstatecode)
发送指令后返回接收状态

##### fEvtKpMsg
- **主题**：/basestation/{baseSN}/receive
- **功能描述**：返回短信息是否成功发送至键盘
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|array|-|否|传送参数的对象数组|
|++keySn|string||是|键盘SN|
|++state|string||是|短信息是否成功发送<br>0 - 成功<br>1 - 超时失败<br>2 - 参数错误 |

- **示例代码**
```json
{
  "fun":"fEvtKpMsg",
  "dataTag":"1",
  "data": [
    {
      "keySn": "1479824643",
      "state": "0"
    },
    {
      "keySn": "1479824644",
      "state": "1"
    }
  ]
}
```

### 待机实时反馈
#### 方法
##### setKpStbResponse
- **主题**：/client/{baseSN}/send
- **功能描述**：启动待机实时反馈
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+state|int||是|启用待机实时反馈<br>0-不启用<br>1-启用|
|+mode|int||是|启动待机反馈类型，state=1时有效<br>0-举手<br>1-指定按键反馈|
|+keys|int||是|有效按键数量，state=1且mode=1时有效, 范围1-10|

- **示例代码**
```json
//启用举手反馈
{
  "fun":"setKpStbResponse",
  "dataTag":"1",
  "data":{
    "state":1,
    "mode":0
  }
}
//启用待机按键反馈
{
  "fun":"setKpStbResponse",
  "dataTag":"1",
  "data":{
    "state":1,
    "mode":1,
    "keys":4
  }
}
//关闭待机按键反馈
{
  "fun":"setKpStbResponse",
  "dataTag":"1",
  "data":{
    "state":0
  }
}
```

##### getKpStbResponse
- **主题**：/client/{baseSN}/send
- **功能描述**：获取实时反馈是否打开
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
//获取实时反馈状态
{
  "fun":"getKpStbResponse",
  "dataTag":"1"
}
```

#### 事件
##### fEvtKpStbResponse
- **主题**：/basestation/{baseSN}/receive
- **功能描述**：返回当前待机按键反馈开启状态
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|array|-|是|传送参数的对象数组|
|+state|int||是|启用待机实时反馈<br>0-未启用<br>1-启用|
|+mode|int||是|当前启动待机反馈类型，state=1时返回<br>0-举手<br>1-指定按键反馈|

- **示例代码**
```json
//当前启用待机实时反馈，模式为指定按键反馈
{
  "fun":"fEvtKpStbResponse",
  "dataTag":"1",
  "data": {
    "state": 1,
    "mode": 1
  }
}

//当前未启用待机反馈
{
  "fun":"fEvtKpStbResponse",
  "dataTag":"1",
  "data": {
    "state": 0
  }
}
```

##### [sEvtKpRtFeedback](#sevtkprtfeedback)
返回待机时键盘返回的按键值

##### [sEvtKpHandup](#sevtkphandup)
启动待机按键反馈类型为举手提问时返回此事件

## 在线测验
### 标准测验
#### 方法
##### startKpExam
- **主题**：/client/{baseSN}/send
- **功能描述**：启动标准测验
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+examNo|int||是|0-9999<br>=0，新的测验<br>>0时,与上次启动卷号一致继续测验，不一致进入新的测验|
|+mode|int||是|显示模式<br>0-不显示开头<br>1-显示“Q”开头<br>2-显示“题”开头|
|+questions|array||是|题目详情|
|++quesType | int||是| 题目类型<br>1:单选<br>2:多选（排序）<br>3:数字<br>4:判断 <br>5:自判题|
|++option |int||是 |选项数目<br> quesType = 1 有效。<br>quesType = 2 有效。<br>此项缺省时  默认4;<br>范围：1-10。|
|++startNo | string||是| 起始题号,可以为数字+“-”，单级的题号数字范围1-255，如“1”，“1-1”，“1-1-1”，最多只能输入三级<br>mode=0 时有效，mode=1或2时键盘按顺序显示题号|
|++count | int||是| 相同参数的连续题目数量, >0 <br>注意：总题数最多支持200题 |<inner>
|+simParams|object||否|内部模拟测试参数设置对象|
|++answer|array||是|预设提交的按键值<br>格式为"单选题答案,多选题答案;<br>数字题答案;判断题答案(1对2错)"<br>如["A","ABCD","10","1"]|</inner>

- **示例代码**

**常用样例**：一级题型 + 显示“Q”开头, 单一题型，全单选题共10题
```json
{
  "fun":"startKpExam",
  "dataTag":"1",
  "data":{
    "mode": 1,
    "examNo": 0,
    "questions": [{          
        "quesType": 1,  //单选题
        "startNo": "1",  //题号从1开始
        "count":10  //连续10题
      }]
  }
}
```

指令样例：一级题型 + 不显示开头，总题数6题
```json
{
  "fun":"startKpExam",
  "dataTag":"1",
  "data":{
    "mode": 0,
    "examNo": 0,
    //第1、2题单选题，第3、4题多选题，第5题数字，第6题判断，共6题
    "questions": [{ 
        "quesType": 1,  //单选题
        "startNo": "1",  //题号从1开始
        "count":2  //连续2题
      },{
        "quesType": 2,  //多选题
        "startNo": "3",  //题号从3开始
        "count":2,  //连续2题
        "option":5   
      },{
        "quesType": 1,  //数字题
        "startNo": "5",  //题号从5开始
        "count":1  //连续1题
      },{
        "quesType": 4,  //判断题
        "startNo": "6",  //题号从6开始
        "count":1  //连续1题
      }]
  }
}
```

指令样例：二级题型 + 不显示开头，总题数6题
```json
{
  "fun":"startKpExam",
  "dataTag":"1",
  "data":{
    "mode": 0,
    "examNo": 0,
    //第1-1、1-2题单选题，第2-1、2-2题多选题，第3-1题数字，第4-1题判断，共6题
    "questions": [{  
        "quesType": 1,  //单选题
        "startNo": "1-1",  //题号从1-1开始
        "count":2  //连续2题
      },{
        "quesType": 2,  //多选题
        "startNo":"2-1",  //题号从2-1开始
        "count":2,  //连续2题
        "option":5 
      },{
        "quesType": 3,  //数字题
        "startNo":"3-1",  //题号从3-1开始
        "count":1  //连续1题
      },{
        "quesType": 4,  //判断题
        "startNo": "4-1",  //题号从4-1开始
        "count":1  //连续1题
      }]
  }
}
```

指令样例：三级题型 + 不显示开头，总题数6题
```json
{
  "fun":"startKpExam",
  "dataTag":"1",
  "data":{
    "mode": 0,
    "examNo": 0,
    //第1-1-1、1-1-2题单选题，第1-2-1、1-2-2题多选题，第2-1-1题数字，第3-1-1题判断，共6题
    "questions": [{        
        "quesType": 1,  //单选题
        "startNo": "1-1-1",  //题号从1-1-1开始
        "count":2  //连续2题
      },{
        "quesType": 2,  //多选题
        "startNo": "1-2-1",  //题号从1-2-1开始
        "count":2,  //连续2题
        "option":5 
      },{
        "quesType": 3,  //数字题
        "startNo": "2-1-1",  //题号从2-1-1开始
        "count":1  //连续1题
      },{
        "quesType": 4,  //判断题
        "startNo": "3-1-1",  //题号从3-1-1开始
        "count":1  //连续1题
      }]
  }
}
```

指令样例：一级题型 + 显示“Q”开头, 共6题
```json
{
  "fun":"startKpExam",
  "dataTag":"1",
  "data":{
    "mode": 1,
    "examNo": 0,
    "questions": [{  
        "quesType": 1,  //单选题
        "startNo": "1",  //题号从1开始
        "count":2  //连续2题
      },{
        "quesType": 2,  //多选题
        "startNo": "3",  //题号从3开始
        "count":2,  //连续2题
        "option":5   
      },{
        "quesType": 1,  //数字题
        "startNo": "5",  //题号从5开始
        "count":1  //连续1题
      },{
        "quesType": 4,  //判断题
        "startNo": "6",  //题号从6开始
        "count":1  //连续1题
      }]
  }
}
```

指令样例：一级题型 + 显示“题”开头, 共6题
```json
{
  "fun":"startKpExam",
  "dataTag":"1",
  "data":{
    "mode": 2,
    "examNo": 0,
    "questions": [{  
        "quesType": 1,  //单选题
        "startNo": "1",  //题号从1开始
        "count":2  //连续2题
      },{
        "quesType": 2,  //多选题
        "startNo": "3",  //题号从3开始
        "count":2,  //连续2题
        "option":5   
      },{
        "quesType": 1,  //数字题
        "startNo": "5",  //题号从5开始
        "count":1  //连续1题
      },{
        "quesType": 4,  //判断题
        "startNo": "6",  //题号从6开始
        "count":1  //连续1题
      }]
  }
}
```

<!-- ##### stopKpExam
- **主题**：/client/{baseSN}/send
- **功能描述**：停止标准测验
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**

```json
{
  "fun":"stopKpExam",
  "dataTag":"1"
}
``` -->
##### [stopKpVote](#stopkpvote)
停止在线测验

<inner>

##### rtGetKpExamData
- **主题**：/client/{baseSN}/send
- **功能描述**：刷新作答数据
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+keySns|array||是|指定的键盘SN数组，空数组表示全部在线键盘|

- **示例代码**
```json
{
  "fun":"rtGetKpExamData",
  "dataTag":"1",
  "data":{
    "keySns":["1234567890","1234567891"]
  }
}
```
</inner>

##### rtKpAllowEdited
- **主题**：/client/{baseSN}/send
- **功能描述**：键盘提交后，允许键盘修改答案
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+keySns|array||是|指定的键盘SN数组，空数组表示全部在线键盘|

- **示例代码**

```json
{
  "fun":"rtKpAllowEdited",
  "dataTag":"1",
  "data":{
    "keySns":["1234567890","1234567891"]
  }
}
```
#### 事件
##### [sEvtStateCode](#sevtstatecode)
发送指令后返回接收状态

##### fEvtKpExam
- **主题**：/basestation/{baseSN}/receive
- **功能描述**：返回键盘提交答题信息
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|array|-|是|传送参数的对象数组|
|++keySn|string||是|键盘SN|
|++keyValue|string||是|键盘提交的按键值,1:A;2:B表示第1题提交A，第二题提交B<br><font color="red">注意：如启动的是多科测验，键盘提交的题目序号对应启动时下发的题目总序号，不按科目区分</font>|
|++keyTime|double||是|答题时间，从启动开始计算，单位秒|
|++voltage|double||是|键盘电量|
|++retryCount|int||是|键盘提交数据的重发次数|

- **示例代码**

```json
{
  "fun":"fEvtKpExam",
  "dataTag":"1",
  "data": [{
      "keySn": "1234567890",
      "keyValue":"1:A;2:B",
      "keyTime":3.2
    },
    {
      "keySn": "1234567891",
      "keyValue":"1:B;2:B",
      "keyTime":3.5
    }
  ]
}
```
##### fEvtFinalSubmit
- **主题**：/basestation/{baseSN}/receive
- **功能描述**：返回键盘手动交卷标识
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|array|-|是|传送参数的对象数组|
|++keySn|string||是|键盘SN|
|++keyValue|string||是|0 - 未提交(提交完成后，允许键盘修改答案时上报)<br>1 - 已交卷|
|++keyTime|double||是|提交时间，从启动开始计算，单位秒|

- **示例代码**

```json
{
  "fun":"fEvtFinalSubmit",
  "dataTag":"1",
  "data": [{
      "keySn": "1234567890",
      "keyValue":"1",
      "keyTime":3.2
    }]
}
```

### 多科测验
#### 方法
##### startKpMultiExam
- **主题**：/client/{baseSN}/send
- **功能描述**：启动多科测验
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+examNo|int||是|0-9999<br>=0，新的测验<br>>0时,与上次启动卷号一致继续测验，不一致进入新的测验|
|+mode|int||是|显示模式<br>0-不显示开头<br>1-显示“Q”开头<br>2-显示“题”开头|
|+questions|array||是|题目详情|
|++subject | int||是 | 科目序号,1-11,对应键盘中内置的科目1-11<br>键盘答题时可选择科目切换答题|
|++quesType | int||是| 题目类型<br>1:单选<br>2:多选（排序）<br>3:数字<br>4:判断<br>5:自判题|
|++option |int||是 |选项数目<br> quesType = 1 有效。<br>quesType = 2 有效。<br>此项缺省时  默认4;<br>范围：1-10。|
|++startNo | string||是| 起始题号,可以为数字+“-”，单级的题号数字范围1-255，如“1”，“1-1”，最多支持两级题号<br>mode=0 时有效，mode=1或2时键盘按顺序显示题号|
|++count | int||是| 相同参数的连续题目数量, >0 <br><font color="red">注意：所有科目的总题数最多支持200题</font>|<inner>
|+simParams|object||否|内部模拟测试参数设置对象|
|++answer|array||是|预设提交的按键值<br>格式为"单选题答案,多选题答案;<br>数字题答案;判断题答案(1对2错)"<br>如["A","ABCD","10","1"]|</inner>

- **示例代码**
```json
//自定义题号
{
  "fun":"startKpMultiExam",
  "dataTag":"1",
  "data":{
    "mode": 0,
    "examNo": 0,
    "questions": [{
        "subject":1,   //科目1
        //题号1-1 到1-10 共10题单选
        "quesType": 1,
        "startNo": "1-1",
        "count":10
      }, {
        "subject":2,   //科目2
        //题号2-2和2-3共两题 多选题，5个选项
        "quesType": 2,
        "option": 5,
        "startNo": "2-2",
        "count":2
      }, {
        "subject":3,   //科目3
        //题号3-1和3-2共两道数字题
        "quesType": 3,
        "startNo": "3-1",
        "count":2
      }, {
        "subject":1,   //科目1
        //题号4和5 ，判断题
        "quesType": 4,
        "startNo": "4",
        "count":2
      }]
  }
}

//显示Q开头
{
  "fun":"startKpMultiExam",
  "dataTag":"1",
  "data":{
    "mode": 1,
    "examNo": 0,
    "questions": [{
        "subject":1,
        //Q1-Q20,单选题
        "quesType": 1,
        "startNo": "1",
        "count":20
      }]
  }
}

//显示题开头
{
  "fun":"startKpMultiExam",
  "dataTag":"1",
  "data":{
    "mode": 2,
    "examNo": 0,
    "questions": [{
        "subject":1,
        //题1-题20,单选题
        "quesType": 1,
        "startNo": "1",
        "count":20
      }]
  }
}
```

<!-- ##### stopKpMultiExam
- **主题**：/client/{baseSN}/send
- **功能描述**：停止多科测验
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"stopKpMultiExam",
  "dataTag":"1"
}
``` -->
##### [stopKpVote](#stopkpvote)
停止多科测验

#### 事件
##### [sEvtStateCode](#sevtstatecode)
发送指令后返回接收状态

##### [fEvtKpExam](#fevtkpexam)
返回测验中键盘提交答题数据

##### [fEvtFinalSubmit](#fevtfinalsubmit)
返回键盘手动交卷标识

### 自主录分
#### 方法
##### startKpScoreInput
- **主题**：/client/{baseSN}/send
- **功能描述**：启动自主录分
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+examNo|int||是|0-9999<br>=0，新的录分<br>>0时,与上次启动卷号一致继续录分，不一致进入新的录分|
|+mode|int||是|录分模式<br>0-自主录分<br>1-交叉录分，需先输入录分的人员标识|
|+questions|array||是|题目详情|
|++max |int||是|可输入的最大值，<=100|
|++digits|int||是|可输入的小数位数，范围0-2|
|++startNo | string||是| 起始题号，暂只支持一级题号，范围1-255|
|++count | int||是| 相同参数的题目数量，>0<br>注意：总题数最多支持200题|

- **示例代码**
```json
{
  "fun":"startKpScoreInput",
  "dataTag":"1",
  "data":{
    "mode": 0,
    "examNo": 0,
    "questions": [{
      //题号1 到 2 共2题,单题满分10分
      "max":10,
      "digits":1,
      "startNo": "1",
      "count":2
    }, {
      //题号3到6 共4道题，单题满分5
      "max":5,
      "digits":0,
      "startNo": "3",
      "count":4
    }]
  }
}
```
<!-- 
##### stopKpScoreInput
- **主题**：/client/{baseSN}/send
- **功能描述**：停止自主录分
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"stopKpScoreInput",
  "dataTag":"1"
}
``` -->
##### [stopKpVote](#stopkpvote)
停止自主录分

#### 事件
##### [sEvtStateCode](#sevtstatecode)
发送指令后返回接收状态

##### fEvtKpScore
- **主题**：/basestation/{baseSN}/receive
- **功能描述**：返回键盘提交录分信息
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|array|-|是|传送参数的对象数组|
|++keySn|string||是|键盘SN|
|++keyValue|string||是|键盘提交的分值,1:10;2:0表示第1题提交10分，第二题提交0分|
|++keyTime|double||是|录分时间，从启动录分开始计算，单位秒|
|++voltage|double||是|键盘电量|
|++retryCount|int||是|键盘提交数据的重发次数|

- **示例代码**
```json
{
  "fun":"fEvtKpScore",
  "dataTag":"1",
  "data": [{
      "keySn": "1234567890",
      "keyValue":"1:8;2:7.5;3:2;4:3",
      "keyTime":3.2
    },
    {
      "keySn": "1234567891",
      "keyValue":"1:10;2:0",
      "keyTime":3.5
    }
  ]
}
```

### 自定义测验题型标题
#### 方法
##### setKpExamQuesTitle
- **主题**：/client/{baseSN}/send
- **功能描述**：设置自定义测验题题型标题，键盘需在线才能接收成功。<br>设置完成后启动测验，对应的题型显示为设置的自定义标题。<br><font color="red">题型标题相对固定，下发成功后键盘会保存标题，标题无变化时无需重复下发</font>
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象数组，不可为空|
|+keySns|array||是|需要设置标题的键盘SN数组，为空代表全部在线键盘<br><font color="red">注意：指定键盘下发才有单个键盘下发是否成功的事件，全部在线键盘下发只有统一回复事件</font>|
|+type|int||是|需要设置的题目类型<br>1-单选题<br>2-多选题<br>3-数字题<br>4-判断题<br>5-自判题|
|+title|string||是|设置的标题内容，长度不大于15个字符|


- **示例代码**
```json
//指定下发
{
  "fun":"setKpExamQuesTitle",
  "dataTag":"1",
  "data": {
    "keySns": ["1234567890","1234567891"],
    "type":1,
    "title": "请选择"
  }
}

//统一下发
{
  "fun":"setKpExamQuesTitle",
  "dataTag":"1",
  "data": {
    "keySns": [],
    "type":1,
    "title": "请选择"
  }
}
```

##### clearKpExamQuesTitle
- **主题**：/client/{baseSN}/send
- **功能描述**：清除键盘自定义测验题型标题
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象数组|
|+type|int||是|需要清除自定义标题的题目类型<br>0-所有题型<!--<br>1-单选题<br>2-多选题<br>3-数字题<br>4-判断题<br>5-对错题(自判题)-->|
|+keySns|array||否|需要清除绑定信息键盘SN数组，<br>空数组表示清空所有键盘|

- **示例代码**
```json
{
  "fun":"clearKpExamQuesTitle",
  "dataTag":"1",
  "data": {
    "type":0,
    "keySns":[]
  }
}
```

#### 事件
##### [sEvtStateCode](#sevtstatecode)
发送指令后返回接收状态

##### fEvtKpExamQuesTitle
- **主题**：/basestation/{baseSN}/receive
- **功能描述**：返回键盘设置自定义题型标题的状态是否成功
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|array|-|否|返回的对象数组|
|++keySn|string||是|设置自定义题型的SN，如果未指定键盘，则keySn为空字符串|
|++state|string||是|设置的自定义信息是否成功<br>0 - 成功<br>1 - 失败|

- **示例代码**
```json
//指定下发
{
  "fun":"fEvtKpExamQuesTitle",
  "dataTag":"1",
  "data": [
    {
      "keySn":"1234567890",
      "state": "0"
    },
    {
      "keySn":"1234567891",
      "state": "0"
    }
  ]
}

//统一下发
{
  "fun":"fEvtKpExamQuesTitle",
  "dataTag":"1",
  "data": [
    {
      "keySn":"",
      "state": "0"
    }
  ]
}
```
##### fEvtClearKpExamQuesTitle
- **主题**：/basestation/{baseSN}/receive
- **功能描述**：返回清空自定义题型标题的指令状态是否成功
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|否|传送参数的对象|
|+state|string||是|清空自定义标题是否成功<br>0 - 成功<br>1 - 失败|

- **示例代码**
```json
{
  "fun":"fEvtClearKpExamQuesTitle",
  "dataTag":"1",
  "data": {
    "state": "0"
  }
}
```